% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one_call_pipe_linter.R
\name{one_call_pipe_linter}
\alias{one_call_pipe_linter}
\title{Block single-call magrittr pipes}
\usage{
one_call_pipe_linter()
}
\description{
Prefer using a plain call instead of a pipe with only one call,
i.e. \code{1:10 \%>\% sum()} should instead be \code{sum(1:10)}. Note that
calls in the first \verb{\%>\%} argument count. \code{rowSums(x) \%>\% max()} is OK
because there are two total calls (\code{rowSums()} and \code{max()}).
}
\details{
Note also that un-"called" steps are \emph{not} counted, since they should
be calls (see \code{\link[=pipe_call_linter]{pipe_call_linter()}}).
}
\examples{
# will produce lints
lint(
  text = "(1:10) \%>\% sum()",
  linters = one_call_pipe_linter()
)

lint(
  text = "DT \%>\% .[grp == 'a', sum(v)]",
  linters = one_call_pipe_linter()
)

# okay
lint(
  text = "rowSums(x) \%>\% mean()",
  linters = one_call_pipe_linter()
)

lint(
  text = "DT[src == 'a', .N, by = grp] \%>\% .[N > 10]",
  linters = one_call_pipe_linter()
)

# assignment pipe is exempted
lint(
  text = "DF \%<>\% mutate(a = 2)",
  linters = one_call_pipe_linter()
)

}
\seealso{
\itemize{
\item \link{linters} for a complete list of linters available in lintr.
\item \url{https://style.tidyverse.org/pipes.html#short-pipes}
}
}
\section{Tags}{
\link[=readability_linters]{readability}, \link[=style_linters]{style}
}
