% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.clpca.R
\name{bootstrap.clpca}
\alias{bootstrap.clpca}
\title{Bootstrap procedure for Cumulative Logistic (Restricted) PCA}
\usage{
bootstrap.clpca(object, Bsamples = 1000, myseed = 1)
}
\arguments{
\item{object}{An output object from clpca}

\item{Bsamples}{Number of Bootstrap samples to take}

\item{myseed}{A seed number to make the bootstrap reproducible}
}
\value{
BBdf Bootstrap estimates of B

BVdf Bootstrap estimates of V
}
\description{
Bootstrap procedure for Cumulative Logistic (Restricted) PCA
}
\examples{
\dontrun{
data(dataExample_clpca)
Y<-as.matrix(dataExample_clpca[,5:8])
X<-as.matrix(dataExample_clpca[,1:4])
# supervised
output = clpca(Y = Y, X = X, S = 2)
boot.output = bootstrap.clpca(output, Bsamples = 100)
plot(boot.output)
}

}
