% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrrr.R
\name{mrrr}
\alias{mrrr}
\title{Multinomial Reduced Rank Regression}
\usage{
mrrr(y, X, S = 2, trace = FALSE, maxiter = 65536, dcrit = 1e-06, start = NULL)
}
\arguments{
\item{y}{An N vector of the responses (categorical).}

\item{X}{An N by P matrix with predictor variables}

\item{S}{Positive number indicating the dimensionality of teh solution}

\item{trace}{Boolean indicating whether a trace of the algorithm should be printed on the console.}

\item{maxiter}{maximum number of iterations}

\item{dcrit}{convergence criterion}

\item{start}{start values. If start=NULL, the algorithm computes the start values.}
}
\value{
Xoriginal Matrix X from input

X Scaled X matrix

G class indicator matrix

ynames class names of response classes

xnames variable names of the predictors

mx means of the predictor variables

sdx standard deviations of the predictor variables

U coordinate matrix of row objects

B matrix with regression coefficients

V Class coordinate matrix

iters number of iterations

deviance value of the deviance at convergence
}
\description{
The function mrrr performs multinomial reduced rank regression for a nominal response
variable and a set of predictor variables.
}
\examples{
\dontrun{
data(dataExample_mru)
y = as.matrix(dataExample_mru[ , 1])
X = as.matrix(dataExample_mru[ , 2:6])
output = mrrr(y = y, X = X, S = 2)
}

}
