% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.mru.R
\name{predict.mru}
\alias{predict.mru}
\title{The function predict.mru makes predictions for a test/validation set
 based on a fitted mru model}
\usage{
\method{predict}{mru}(object, newX, newG = NULL, ...)
}
\arguments{
\item{object}{An \code{mru} object}

\item{newX}{An N by P matrix with predictor variables for a test/validation set}

\item{newG}{An N by R matrix with response variables  for a test/validation set}

\item{\dots}{additional arguments to be passed.}
}
\value{
This function returns an object of the class \code{p.mru} with components:
\item{Yhat}{Predicted values for the test set}
\item{dev}{Estimated prediction deviance}
}
\description{
The function predict.mru makes predictions for a test/validation set
 based on a fitted mru model
}
\examples{
\dontrun{
data(dataExample_lpca)
Y = as.matrix(dataExample_mru[-c(1:20) , 1:8])
X = as.matrix(dataExample_mru[-c(1:20) , 9:13])
newY = as.matrix(dataExample_mru[1:20 , 1:8])
newX = as.matrix(dataExample_mru[1:20 , 9:13])
# supervised
output = mru(Y = Y, X = X, S = 2)
preds = predict(output, newX = newX, newY = newY)
}


}
