% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrange_data.R
\name{arrange_data}
\alias{arrange_data}
\title{Arrange Data for Free Recall Scoring}
\usage{
arrange_data(data, responses, sep, id, repeated = NULL)
}
\arguments{
\item{data}{a dataframe of the variables you would like to return.
Other variables will be included in the returned output in long format
if they represent a one to one match with the participant ID. If you
have repeated data, please use the repeated argument or run this
function several times for each trial.}

\item{responses}{a column name in the dataframe that contains
the participant answers for each item in quotes (i.e., "column")}

\item{sep}{a character separating each response in quotes - example: ",".}

\item{id}{a column name containing participant ID numbers from
the original dataframe}

\item{repeated}{(optional) a single column name or set of columns
that indicate repeated measures columns you would like to
keep with the data. You should include all columns that are not a one
to one match with the subject ID (i.e., participants saw multiple
trials). Please see our vignette for an example.}
}
\value{
A dataframe of the participant answers including:
\item{Sub.ID}{The participant id number}
\item{response}{The participant response}
\item{position}{The position number of the response listed}
\item{other}{Any additional columns included}
}
\description{
This function takes wide format free recall data where all
responses are stored in the same cell and converts it to long format.
}
\examples{

#This dataset includes a subject number, set of answers, and
#experiment condition.

data(wide_data)

DF_long <- arrange_data(
 data = wide_data,
 responses = "Response",
 sep = ",",
 id = "Sub.ID")

head(DF_long)

}
\keyword{arrange}
\keyword{data}
\keyword{long}
\keyword{wide}
