% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solar_day_info.R
\name{solar_day_info}
\alias{solar_day_info}
\title{Identify Solar Day Information}
\usage{
solar_day_info(
  lat = NULL,
  lon = NULL,
  start_date = NULL,
  end_date = NULL,
  quiet = FALSE
)
}
\arguments{
\item{lat}{(numeric) latitude coordinate for which to find day length}

\item{lon}{(numeric) longitude coordinate for which to find day length}

\item{start_date}{(character) starting date in 'YYYY-MM-DD' format}

\item{end_date}{(character) ending date in 'YYYY-MM-DD' format}

\item{quiet}{(logical) whether to suppress certain non-warning messages. Defaults to \code{TRUE}}
}
\value{
(dataframe) table of 6 columns and a number of rows equal to the number of days between the specified start and end dates (inclusive). Columns contain: (1) date, (2) sunrise time, (3) sunset time, (4) solar noon, (5) day length, and (6) time zone of columns 2 to 4.
}
\description{
For all days between the specified start and end date, identify the time of sunrise, sunset, and solar noon (in UTC) as well as the day length. The idea for this function was contributed by \href{https://luquillo.lter.network/}{Miguel C. Leon} and a Python equivalent lives in the Luquillo site's \href{https://github.com/LUQ-LTER/LUQ-general-utils}{LUQ-general-utils GitHub repository}.
}
\examples{
\dontrun{
# Identify day information in Santa Barbara (California) for one week
solar_day_info(lat = 34.416857, lon = -119.712777, 
               start_date = "2022-02-07", end_date = "2022-02-12", 
               quiet = TRUE)
}
}
