% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_linkage_groups.R
\name{compute_linkage_groups}
\alias{compute_linkage_groups}
\title{Compute Linkage groups}
\usage{
compute_linkage_groups(orthologs_df)
}
\arguments{
\item{orthologs_df}{dataframe. orthologs with genomic coordinates loaded with load_orthologs()}
}
\value{
A dataframe object
}
\description{
This is a function to compute the conserved linkage groups shared between two or more species.
It computes the significant associations between chromosomes of all species versus all (pairwise)
using the fischer test implemented in compute_macrosynteny().
It outputs a dataframe shaped as following :
sp1.Chr,sp2.Chr,..., spN.chr,n,LGs
where n is the number of shared orthologs in the group and LGs are the IDs for the linkage groups
}
\examples{
# basic usage of compute_linkage_groups: 

orthologs_table <- system.file("extdata","my_orthologs.tab",package="macrosyntR")

my_orthologs <- read.table(orthologs_table,header=TRUE)
                               
my_macrosynteny <- compute_linkage_groups(my_orthologs)

}
