% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experimental.R
\name{data_dict_trim_labels}
\alias{data_dict_trim_labels}
\title{Add shortened labels to data dictionary}
\usage{
data_dict_trim_labels(
  data_dict,
  max_length_var_name = 31,
  max_length_var_label = 255,
  max_length_cat_name = 15,
  max_length_cat_label_short = 15,
  max_length_cat_label_long = 63,
  .keep_columns = TRUE
)
}
\arguments{
\item{data_dict}{A data dictionary, typically a list containing 'Variables'
and 'Categories' data frames.}

\item{max_length_var_name}{An integer specifying the maximum length for
variable names (default is 10).}

\item{max_length_var_label}{An integer specifying the maximum length for
variable labels (default is 255).}

\item{max_length_cat_name}{An integer specifying the maximum length for
category names (default is 10).}

\item{max_length_cat_label_short}{An integer specifying the maximum total length
for category labels (short) (default is 15).}

\item{max_length_cat_label_long}{An integer specifying the maximum total length
for category labels (long) (default is 63).}

\item{.keep_columns}{A boolean specifying if the output preserves the other
columns of the data dictionary or not.}
}
\value{
A modified data dictionary with additional columns for shortened labels:
\itemize{
\item \code{madshapR::label_var_short}: Shortened variable labels.
\item \code{madshapR::label_cat_long}: Shortened category labels (if categories are present).
}
}
\description{
This function modifies a data dictionary by adding shortened labels for both
variables and categories. The shortened labels are created based on specified
maximum lengths for the variable and category names and labels.
The function first validates the input using \code{as_data_dict_shape} and extracts the
first variable and category labels using \code{first_label_get}. It then calculates the
lengths of names and labels, ensuring that they do not exceed the specified maximum
lengths. The function handles both variables and categories, creating short labels
while replacing any missing values with "Empty".
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.
}
\examples{
{

 # use madshapR_examples provided by the package
 data_dict <- madshapR_examples$`data_dictionary_example - errors`
 data_dict_with_short_labels <- data_dict_trim_labels(data_dict)
 
 attributes(data_dict_with_short_labels)

}

}
