% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{mandelbrot_palette}
\alias{mandelbrot_palette}
\title{Generate palette suitable for coloring a set}
\usage{
mandelbrot_palette(palette, fold = TRUE, reps = 1L, in_set = "black")
}
\arguments{
\item{palette}{vector of color hex strings (e.g. '#FFFFFF')}

\item{fold}{wrap or fold the palette back on itself}

\item{reps}{number of times to replicate the color vector}

\item{in_set}{color for areas in the Mandelbrot set}
}
\value{
an extended color vector
}
\description{
Takes a simple palette and expands / oscillates
it for use with Mandelbrot sets.
}
\examples{
view <- mandelbrot(xlim = c(-0.8438146, -0.8226294),
  ylim = c(0.1963144, 0.2174996), iter = 500)

# can be used to simply interpolate a color gradient
spectral <- RColorBrewer::brewer.pal(11, "Spectral")
cols <- mandelbrot_palette(spectral, fold = FALSE)
plot(view, col = cols, transform = "inv")

# simple palettes might need folds / reps to look good
blues <- RColorBrewer::brewer.pal(9, "Blues")
cols <- mandelbrot_palette(blues, in_set = "white",
  fold = TRUE, reps = 2)
plot(view, col = cols, transform = "log")

}
