% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_comarca.R
\name{esp_get_comarca}
\alias{esp_get_comarca}
\title{Get 'comarcas' of Spain as \code{\link[sf:sf]{sf}} \code{POLYGON}}
\source{
INE: PC_Axis files, IGN, Ministry of Agriculture, Fisheries and Food (MAPA).
}
\usage{
esp_get_comarca(
  region = NULL,
  comarca = NULL,
  moveCAN = TRUE,
  type = c("INE", "IGN", "AGR", "LIV"),
  epsg = "4258",
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{region}{A vector of names and/or codes for provinces or \code{NULL} to get
all the comarcas. See \strong{Details}.}

\item{comarca}{A name or \code{\link[base:grep]{regex}} expression with the names of
the required comarcas. \code{NULL} would return all the possible comarcas.}

\item{moveCAN}{A logical \code{TRUE/FALSE} or a vector of coordinates
\code{c(lat, lon)}. It places the Canary Islands close to Spain's mainland.
Initial position can be adjusted using the vector of coordinates. See
\strong{Displacing the Canary Islands}.}

\item{type}{One of \code{"INE"}, \code{"IGN"}, \code{"AGR"}, \code{"LIV"}. Type of comarca to
return, see \strong{Details}.}

\item{epsg}{projection of the map: 4-digit \href{https://epsg.io/}{EPSG code}.
One of:
\itemize{
\item \code{"4258"}: ETRS89.
\item \code{"4326"}: WGS84.
\item \code{"3035"}: ETRS89 / ETRS-LAEA.
\item \code{"3857"}: Pseudo-Mercator.
}}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source file.}

\item{cache_dir}{A path to a cache directory. See \strong{About caching}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}
}
\value{
A \code{\link[sf:sf]{sf}} polygon object.
}
\description{
Returns 'comarcas' of Spain as \code{sf} \code{POLYGON} objects.
}
\details{
\subsection{About comarcas}{

'Comarcas' (English equivalent: district, county, area or zone) does not
always have a formal legal status. They correspond mainly to natural areas
(valleys, river basins etc.) or even to historical regions or ancient
kingdoms.

In the case of Spain, comarcas only have an administrative character legally
recognized in Catalonia, the Basque Country, Navarra (named merindades
instead), in the region of El Bierzo (Castilla y Leon) and Aragon. Galicia,
the Principality of Asturias, and Andalusia have functional comarcas.
}

\subsection{Types}{

\code{esp_get_comarca()} can retrieve several types of comarcas, each one
provided under different classification criteria.
\itemize{
\item \code{"INE"}: Comarcas as defined by the National Statistics Institute (INE).
\item \code{"IGN"}: Official comarcas, only available on some Autonomous Communities,
provided by the National Geographic Institute.
\item \code{"AGR"}: Agrarian comarcas defined by the Ministry of Agriculture,
Fisheries and Food (MAPA).
\item \code{"LIV"}: Livestock comarcas defined by the Ministry of Agriculture,
Fisheries and Food (MAPA).
}
}

\subsection{Misc}{

When using \code{region} you can use and mix names and NUTS codes
(levels 1, 2 or 3), ISO codes (corresponding to level 2 or 3) or
"cpro" (see \link{esp_codelist}).

When calling a higher level (Province, Autonomous Community or NUTS1),
all the comarcas of that level would be added.
}

\subsection{Legal Notice}{

The use of the information contained on the
\href{https://www.ine.es/en/index.htm}{INE website} may be carried out by users or
re-use agents, at their own risk, and they will be the sole liable parties
in the case of having to answer to third parties due to damages arising
from such use.
}
}
\section{About caching}{
You can set your \code{cache_dir} with \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.

Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding .geojson file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.
}

\section{Displacing the Canary Islands}{
While \code{moveCAN} is useful for visualization, it would alter the actual
geographic position of the Canary Islands. When using the output for
spatial analysis or using tiles (e.g. with \code{\link[=esp_getTiles]{esp_getTiles()}} or
\code{\link[=addProviderEspTiles]{addProviderEspTiles()}})  this option should be set to \code{FALSE} in order to
get the actual coordinates, instead of the modified ones. See also
\code{\link[=esp_move_can]{esp_move_can()}} for displacing stand-alone \code{\link[sf:sf]{sf}} objects.
}

\examples{
\dontshow{if (esp_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
comarcas <- esp_get_comarca(moveCAN = FALSE)

library(ggplot2)

ggplot(comarcas) +
  geom_sf()

# IGN provides recognized comarcas

rec <- esp_get_comarca(type = "IGN")

ggplot(rec) +
  geom_sf(aes(fill = t_comarca))

# Legal Comarcas of Catalunya

comarcas_cat <- esp_get_comarca("Catalunya", type = "IGN")

ggplot(comarcas_cat) +
  geom_sf(aes(fill = ine.prov.name)) +
  labs(fill = "Province")
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other political: 
\code{\link{esp_codelist}},
\code{\link{esp_get_can_box}()},
\code{\link{esp_get_capimun}()},
\code{\link{esp_get_ccaa}()},
\code{\link{esp_get_country}()},
\code{\link{esp_get_gridmap}},
\code{\link{esp_get_munic}()},
\code{\link{esp_get_nuts}()},
\code{\link{esp_get_prov}()},
\code{\link{esp_get_simpl_prov}()}
}
\concept{political}
