% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_grid_BDN.R
\name{esp_get_grid_BDN}
\alias{esp_get_grid_BDN}
\alias{esp_get_grid_BDN_ccaa}
\title{Get \code{\link[sf:sf]{sf}} \code{POLYGON} with the national geographic grids from BDN}
\source{
BDN data via a custom CDN (see
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata/MTN}).

See original metadata and source on
\url{https://www.miteco.gob.es/es/biodiversidad/servicios/banco-datos-naturaleza/informacion-disponible/bdn-cart-aux-descargas-ccaa.html}
}
\usage{
esp_get_grid_BDN(
  resolution = 10,
  type = "main",
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)

esp_get_grid_BDN_ccaa(
  ccaa,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{resolution}{Resolution of the grid in kms. Could be \code{5} or \code{10}.}

\item{type}{The scope of the grid. It could be mainland Spain (\code{"main"}) or
the Canary Islands (\code{"canary"}).}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source file.}

\item{cache_dir}{A path to a cache directory. See \strong{About caching}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}

\item{ccaa}{A vector of names and/or codes for autonomous communities.
See \strong{Details} on \code{\link[=esp_get_ccaa]{esp_get_ccaa()}}.}
}
\value{
A \code{\link[sf:sf]{sf}} \code{POLYGON}.
}
\description{
Loads a \code{\link[sf:sf]{sf}} \code{POLYGON} with the geographic grids of Spain as
provided on the Banco de Datos de la Naturaleza (Nature Data Bank), by the
Ministry of Environment (MITECO):
\itemize{
\item \code{\link[=esp_get_grid_BDN]{esp_get_grid_BDN()}} extracts country-wide grids with resolutions
5x5 or 10x10 kms.
\item \code{\link[=esp_get_grid_BDN_ccaa]{esp_get_grid_BDN_ccaa()}} extracts grids by Autonomous Community with
resolution 1x1 km.
}
}
\section{About caching}{
You can set your \code{cache_dir} with \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.

Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding .geojson file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.
}

\examples{
\dontshow{if (esp_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
grid <- esp_get_grid_BDN(resolution = "10", type = "main")

library(ggplot2)

ggplot(grid) +
  geom_sf() +
  theme_light() +
  labs(title = "BDN Grid for Spain")
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=esp_get_ccaa]{esp_get_ccaa()}}

Other grids: 
\code{\link{esp_get_grid_EEA}()},
\code{\link{esp_get_grid_ESDAC}()},
\code{\link{esp_get_grid_MTN}()}
}
\concept{grids}
