% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulate.Weights.R
\name{Sim.Const.Weights}
\alias{Sim.Const.Weights}
\title{Simulation of constrained weights}
\usage{
Sim.Const.Weights(n, utilities, alpha, constraints)
}
\arguments{
\item{n}{number of simulations}

\item{utilities}{utility dataframe, first column is the identifier}

\item{alpha}{concentration parameter for the Dirichlet distribution}

\item{constraints}{list of sum constraints}
}
\value{
List with data.frames \{simulation, weights\} with total utilities and simulated weights
}
\description{
Simulation of weights employing the Dirichlet distribution. The concentration 
parameters for the Dirichlet distribution are tentative weights, additionally constraints over
partial sums of weights are introduced by a list ordered structure.
}
\details{
Employing the properties of the Dirichlet distribution, weights could be simulated 
with a given concentration, additionally this simulation can be carry out by subsets of weights
only to meet specific constraints.
}
\examples{
library( data.table )
N<-10
utilities<-data.table( id = 1:N, 
                       u1 = runif( N, 0, 1 ), 
                       u2 = runif( N, 0, 1 ), 
                       u3 = runif( N, 0, 1 ),
                       u4 = runif( N, 0, 1 ) )
n<-100
alpha<-c( 0.2, 0.5, 0.1, 0.2 )
constraints<-list( list( c(1,2), 0.7 ), 
                   list( c(3,4), 0.3 ) )
S<-Sim.Const.Weights( n, utilities, alpha, constraints )
plot.S<-Plot.Simulation.Weight( S$simulation, title = 'Simulations', 
                                xlab = 'ID', ylab = 'Utility' ) 
plot( plot.S )
}
\seealso{
\code{\link{Eval.Utilities}}
}
\author{
Pedro Guarderas
\email{pedro.felipe.guarderas@gmail.com}
}
