% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{is_metabodecon_class}
\alias{is_metabodecon_class}
\alias{is_spectrum}
\alias{is_decon0}
\alias{is_decon1}
\alias{is_decon2}
\alias{is_align}
\alias{is_spectra}
\alias{is_decons0}
\alias{is_decons1}
\alias{is_decons2}
\alias{is_aligns}
\title{Is an Object from a Metabodecon Class?}
\usage{
is_spectrum(x, check_class = TRUE, check_contents = FALSE)

is_decon0(x)

is_decon1(x)

is_decon2(x)

is_align(x)

is_spectra(
  x,
  check_class = TRUE,
  check_contents = FALSE,
  check_child_classes = FALSE
)

is_decons0(x)

is_decons1(x)

is_decons2(x)

is_aligns(x)
}
\arguments{
\item{x}{The object to check.}

\item{check_class}{Logical indicating whether to check the class of the object.}

\item{check_contents}{Logical indicating whether to check the contents of the object.}

\item{check_child_classes}{Logical indicating whether to check the class of each element of the object.}
}
\value{
TRUE if the object is an instance of the specified class, otherwise FALSE.
}
\description{
Check if an object is an instance of a specific 'Metabodecon Class'. See
\href{https://spang-lab.github.io/metabodecon/articles/Classes.html}{Metabodecon Classes} for a
list of classes.
}
\examples{
ss <- sim[1:2]
s1 <- sim[[1]]
is_spectra(ss) # TRUE
is_spectrum(s1) # TRUE
is_spectrum(s1, check_contents = TRUE) # TRUE

dd <- deconvolute(ss, sfr = c(3.55, 3.35))
d1 <- dd[[1]]
is_decons0(dd) # FALSE
is_decons1(dd) # FALSE
is_decons2(dd) # TRUE
is_decon0(d1) # FALSE
is_decon1(d1) # FALSE
is_decon2(d1) # TRUE

if (interactive()) {
    # Example requires an interactive R session, because in case of missing
    # dependencies the user will be asked for confirmation to install them.
    aa <- align(dd)
    a1 <- aa[[1]]
    is_align(a1) # TRUE
    is_aligns(aa) # TRUE
}

}
\author{
2024-2025 Tobias Schmidt: initial version.
}
