% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_comp.R
\name{model_comp}
\alias{model_comp}
\title{compute the model comparison measures: DIC, LPML, or Pearson's residuals}
\usage{
model_comp(object, type = "lpml", verbose = FALSE, ncores = NULL)
}
\arguments{
\item{object}{the output model from fitting a meta analysis/regression model}

\item{type}{the type of model comparison measure to compute; DIC or LPML}

\item{verbose}{FALSE by default; If TRUE, then progress bar will appear}

\item{ncores}{the number of CPU cores to use for parallel processing. It must not exceed the number of existing cores. If unspecified, it will default to 2 cores or the number of existing cores, whichever is smaller.}
}
\value{
dataframe containing the compute the model comparison measures
}
\description{
\code{model_comp} is a generic function that computes the model comparison measures (DIC and LPML) or the Pearson's residuals. Note that the Pearson's residuals are not available for \code{bayes.nmr} when \code{df} is either random or fixed but smaller than 2 since the variance of the random effects is not finite.
}
