% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaprotr_export_vennlists.R
\name{export_vennlists}
\alias{export_vennlists}
\title{export_vennlists}
\usage{
export_vennlists(venn_lists_object, output_repo = NULL, force = FALSE)
}
\arguments{
\item{venn_lists_object}{List defined as "venn_lists_object" containing the
elements (peptides, subgroups, groups or taxonomic elements) 
generated with the function "plot_venn".}

\item{output_repo}{Character indicating the path of a previously 
created directory where the lists will be exported. 
This parameter is optional.}

\item{force}{Logic value set at FALSE by default in order 
to ask permission to create csv files in the workstation of the user.}
}
\value{
csv files containing the elements present on each logic section 
   (specific and intersections) from the list defined as "venn_lists_object".
}
\description{
Exports as csv files the elements (groups, subgroups, peptides or 
taxonomic levels) generated from the function "plot_venn".
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}

data(venn_methods)

export_vennlists(venn_methods)

\dontshow{setwd(.old_wd)}
}
