% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaprotr_filter_unshared.R
\name{filter_unshared}
\alias{filter_unshared}
\title{filter_unshared}
\usage{
filter_unshared(spectral_count_object, metadata_feature)
}
\arguments{
\item{spectral_count_object}{List containing dataframes with proteomics
elements whose abundance is expressed as spectral counts and are
organized by peptides, subgroups, groups or taxonomic levels. 
The format of this object is similar to that generated from 
the functions "getsc_specific" and "crumble_taxonomy".}

\item{metadata_feature}{Character indicating the name of one explanatory 
variable (ONE column name) of the dataframe "metadata".}
}
\value{
A list defined as "spectral_count_object" with the specific 
   elements per sample or condition, having at least one spectra.
}
\description{
Keeps the elements from a "spectral_count_object" that are specific to one
level of a provided explanatory variable. This variable MUST correspond to
the name of ONE column of the dataframe "metadata" (eg. conditions or samples).
This function allows to identify the elements that are specific to one 
condition or one sample.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}

data(fecal_waters)
data(species_fw)

specific_elements_per_sample <- filter_unshared(fecal_waters, "SampleID")

specific_elements_per_condition <- filter_unshared(species_fw, "Condition")

\dontshow{setwd(.old_wd)}
}
