% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaprotr_identify_differences.R
\name{identify_differences}
\alias{identify_differences}
\title{identify_differences}
\usage{
identify_differences(
  spectral_count_object,
  target_variable,
  list_conditions,
  filter_ratio = 3,
  force = FALSE
)
}
\arguments{
\item{spectral_count_object}{List defined as "spectral_count_object" 
containing dataframes with abundance expressed as spectral counts
and organized by taxonomic levels. The format of this object is 
similar to that generated from the function "crumble_taxonomy".}

\item{target_variable}{Character indicating the variable name 
containing the conditions or samples to be compared. This value 
corresponds to the name of one column from metadata.}

\item{list_conditions}{Atomic vector indicating two conditions to 
be compared. The first element will be considered as the reference.}

\item{filter_ratio}{Numeric value indicating the fold change filter 
to be considered for the pairwise comparison. The minimal value can be 
a fold change of 1.25. The default value is set at 3.}

\item{force}{Logic value set at FALSE by default in order to ask 
permission to create an object in the workstation of the user.}
}
\value{
Barplots (pdf) and a csv file with the defferential taxonomic 
   elements between TWO conditions or sample. These elements are those that 
   fulfill the ratio log2 (condition + 1 / reference + 1) > filter_ratio.
}
\description{
Shows the most differential taxonomic elements between two 
conditions or samples from a list defined as "spectral_count_object" 
with taxonomic classification. These elements are those with an 
absolute log2 (condition + 1 / reference + 1) > 3. If a given condition has
several replicates the mean value is taken into account.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}

data(species_fw)
identify_differences(species_fw, "Methods", c("S", "S_EF"))

identify_differences(species_fw, "Methods", c("EF", "S_EF"), filter_ratio = 1.3)

\dontshow{setwd(.old_wd)}
}
