% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaprotr_plot_pca.R
\name{plot_pca}
\alias{plot_pca}
\title{plot_pca}
\usage{
plot_pca(spectral_count_object, colors_var, pc_components, force = FALSE)
}
\arguments{
\item{spectral_count_object}{List described as "spectral_count_object" 
containing dataframes with abundance expressed as spectral counts from 
peptides, subgroups, groups or taxonomic levels. The format of this 
object is similar to that generated from the functions "getsc_specific" and 
"crumble_taxonomy". The PCA projections will be applied to these observations.}

\item{colors_var}{Character indicating the name of one column 
from metadata. The samples will be represented in different colors
in function of the levels of this variable (ex. conditions).}

\item{pc_components}{Two numeric values indicating two principal 
components to be analyzed.}

\item{force}{Logic value set as FALSE by default in order to ask 
permission to create a file in the workstation of the user.}
}
\value{
A pdf file containing the results of PCA applied to the two provided 
   principal components. Including a bar plot indicating the percentage of variance
   per principal component.
}
\description{
Performs a Principal Components Analysis (PCA) from the spectral counts of the entities 
(peptides, subgroups, groups or taxonomic elements) in a 
"spectral_count_object" with or without taxonomy. PCA decomposition of
high dimensional data allows to observe global effects in two dimensions. For more 
details of the used function check dudi.pca from \href{https://CRAN.R-project.org/package=ade4}{ade4}.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}

data(fecal_waters)
plot_pca(fecal_waters, "Methods", c(1, 2))

data(species_fw)
plot_pca(species_fw, "Methods", c(1, 3))

data(species_annot_fw)
plot_pca(species_annot_fw, "Condition", c(1, 2))

\dontshow{setwd(.old_wd)}
}
