% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaprotr_plot_venn.R
\name{plot_venn}
\alias{plot_venn}
\title{plot_venn}
\usage{
plot_venn(
  spectral_count_object,
  target_variable,
  list_conditions,
  force = FALSE
)
}
\arguments{
\item{spectral_count_object}{List defined as "spectral_count_object" 
containing dataframes with abundance expressed as spectral counts 
from peptides, subgroups, groups or taxonomic levels. 
The format of this object is similar to that generated from the 
functions "getsc_specific" and "crumble_taxonomy".}

\item{target_variable}{Character indicating the name of the explanatory 
variable that contains the conditions to be compared. This value corresponds 
to the name of one column from the metadata dataframe.}

\item{list_conditions}{Atomic vector indicating the conditions 
to be compared. The provided elements (2 or 3) must be present in the 
variable indicated as "target_variable".}

\item{force}{Logic value set at FALSE by default in order to ask 
permission to create a pdf file in the workstation of the user.}
}
\value{
A Venn diagram (pdf) and a list defined as "venn_list_object"
   containing the elements (peptides, soubgroups, groups or taxonomic levels) 
   for each logical section of the Venn diagram (specific and intersections).
}
\description{
Generates a Venn diagram comparing up to 3 conditions. The lists of 
elements for each condition are also returned as a "venn_lists_object".
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
data(fecal_waters)
venn_QFW1_Q1 <- plot_venn(fecal_waters, "SC_name", c("Q1_FW1", "Q1"))

data(species_fw)
venn_all <- plot_venn(species_fw, "Methods", c("S_EF", "S", "EF"))
\dontshow{setwd(.old_wd)}
}
