% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmtsl.R
\name{gm.tsl}
\alias{gm.tsl}
\title{Time serie line Graphic Model}
\usage{
gm.tsl(
  data,
  ncolx,
  ncoly,
  ntimes,
  title,
  ylab = NULL,
  percent = FALSE,
  div100 = FALSE,
  fontsize = 0,
  lwdserie = 1,
  datebreaks = "1 months",
  dateformat = "\%b/\%y",
  cserie = "white",
  clines = "white",
  ctext = "white",
  cbackground = "#141414"
)
}
\arguments{
\item{data}{a dataframe}

\item{ncolx}{number of x column in data frame}

\item{ncoly}{number of y column in data frame}

\item{ntimes}{number of observations to plot (count by tail)}

\item{title}{title of plot}

\item{ylab}{y axis label}

\item{percent}{If TRUE y axis in percent (default=F)}

\item{div100}{If data percent are not in decimal format set TRUE.}

\item{fontsize}{change size of all words in graphic (only numbers)}

\item{lwdserie}{size of serie}

\item{datebreaks}{datebreaks in x axis (default="1 month")}

\item{dateformat}{format of date in x axis (need a dataformat string) (default ="\%Y-\%m")}

\item{cserie}{color of serie}

\item{clines}{color of lines in graphic}

\item{ctext}{color of words in graphic}

\item{cbackground}{color of graphic background}
}
\value{
Return a graphic.
}
\description{
gm.tsl make a line plot in time serie format.
Graphic models function family make graphic creation easy, is recommended for new programers,
they have less and easyful parameters then p.tsl but the graphic customize is more limited.
The data don't need be a ts object.
}
\examples{
v=data.frame("x"=seq.Date(as.Date('2020-01-01'),
to = as.Date('2020-04-01'),by='month'),"y"=c(5,3,7,2))

gm.tsl(v,1,2,title="Simple example",ntimes=3)

}
