% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcol.R
\name{p.col}
\alias{p.col}
\title{Bar plot}
\usage{
p.col(
  data,
  xaxis,
  yaxis,
  ybreaks = 10,
  percent = FALSE,
  yaccuracy = 0.01,
  ydecimalmark = ".",
  title = "Title",
  xlab = "X axis",
  ylab = "Y axis",
  stitle = NULL,
  note = NULL,
  ctitles = "black",
  cscales = ctitles,
  cbgrid = "white",
  clgrid = cbgrid,
  cplot = "white",
  cserie = "black",
  cbserie = cserie,
  cticks = "black",
  lwdserie = 1,
  pnote = 1,
  cbord = cplot,
  titlesize = 20,
  wordssize = 12,
  snote = 11,
  xlim = NULL
)
}
\arguments{
\item{data}{a dataframe}

\item{xaxis}{x axis data}

\item{yaxis}{y axis data}

\item{ybreaks}{number of y axis breaks (default=10)}

\item{percent}{If TRUE y axis in percent (default=F)}

\item{yaccuracy}{a round for y axis (default=0.01)}

\item{ydecimalmark}{y decimal mark (default=".")}

\item{title}{title of plot}

\item{xlab}{x axis label}

\item{ylab}{y axis label}

\item{stitle}{subtitle}

\item{note}{note}

\item{ctitles}{color of titles (title,xlab,ylab)}

\item{cscales}{color of the scales (default= same ctitles)}

\item{cbgrid}{color of grid background}

\item{clgrid}{color of grid lines}

\item{cplot}{color of plot background}

\item{cserie}{color of serie}

\item{cbserie}{color of serie border (default= same cserie)}

\item{cticks}{color of axis ticks}

\item{lwdserie}{size of serie}

\item{pnote}{position of note (default=1) (only numbers)}

\item{cbord}{color of plot border (default= same cplot)}

\item{titlesize}{size of title (default=20) (only numbers)}

\item{wordssize}{size of words (default=12) (only numbers)}

\item{snote}{size of note (default=11) (only numbers)}

\item{xlim}{limit of x axis (default=NULL)}
}
\value{
Return a graphic.
}
\description{
p.col make a bar plot.
}
\examples{
v=data.frame("x"=1:5,"y"=c(10,4,8,5,2))
p.col(v,xaxis= v$x,yaxis=v$y)
#or
p.col(v,xaxis= v[[1]],yaxis=v[[2]])

}
