% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rail-times.R
\name{rail_times}
\alias{rail_times}
\title{Rail Station Timings}
\format{
A tibble 1 row per train with 8 variables:
\describe{
\item{StationCode}{Station code for this station. Use this value in other
rail-related APIs to retrieve data about a station.}
\item{StationName}{Full name of the station.}
\item{DestinationStation}{Station code for the train's destination. Use
this value in other rail-related APIs to retrieve data about a station.}
\item{Weekday}{Day of the week abbreviation. From list element names.}
\item{OpeningTime}{Station opening time. Converted to \code{hms} class with
\code{\link[hms:parse_hms]{hms::parse_hm()}}, representing seconds since midnight of that \code{Weekday}.}
\item{FirstTime}{First train leaves the station at this time (ET).
Converted to \code{hms} class with \code{\link[hms:parse_hms]{hms::parse_hm()}}, representing seconds since
midnight of that \code{Weekday}.}
\item{LastTime}{Last train leaves the station at this time (ET). Converted
to \code{hms} class with \code{\link[hms:parse_hms]{hms::parse_hm()}}, representing seconds since midnight
of that \code{Weekday}. For times that were in the AM of the \emph{next} \code{Weekday},
time is greater than 24 hours.}
}
}
\usage{
rail_times(StationCode = NULL, api_key = wmata_key())
}
\arguments{
\item{StationCode}{Station code. Use the \code{\link[=rail_stations]{rail_stations()}} function to return
a list of all station codes. Use \code{NULL} (default) to return times for all
stations.}

\item{api_key}{Subscription key which provides access to this API. Defaults
\code{Sys.getenv("WMATA_KEY")} via \code{\link[=wmata_key]{wmata_key()}}.}
}
\value{
A \emph{tidy} data frame of station schedules. Combined from a nested list
of weekday times.
}
\description{
Returns opening and scheduled first/last train times based on a given
\code{StationCode}. Omit the \code{StationCode} to return timing information for all
stations.
}
\details{
Note that for stations with multiple platforms (e.g.: Metro Center, L'Enfant
Plaza, etc.), a distinct call is required for each \code{StationCode} to retrieve
the full set of train times at such stations.
}
\examples{
\dontrun{
rail_times("A01")
}
}
\seealso{
\url{https://developer.wmata.com/docs/services/5476364f031f590f38092507/operations/5476364f031f5909e4fe3312}

Other Rail Station Information: 
\code{\link{rail_destination}()},
\code{\link{rail_entrance}()},
\code{\link{rail_lines}()},
\code{\link{rail_path}()},
\code{\link{rail_stations}()},
\code{\link{station_info}()}
}
\concept{Rail Station Information}
