% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_levenetest.R
\name{pool_levenetest}
\alias{pool_levenetest}
\title{Calculates the pooled Levene test.}
\usage{
pool_levenetest(object, method = "D1")
}
\arguments{
\item{object}{An object of class 'mistats' ('Multiply Imputed
Statistical Analysis').}

\item{method}{A character vector to choose the pooling method,
'D1' (default) or 'D2'.}
}
\value{
The (combined) F-statistic, p-value and degrees of freedom.
}
\description{
\code{pool_levenetest} Calculates the pooled F-statistic
of the Levenene test.
}
\section{Vignettes}{

https://mwheymans.github.io/miceafter/articles/levene_test.html
}

\examples{
library(magrittr)
lbpmilr \%>\%
   df2milist(impvar="Impnr") \%>\%
      with(expr=levene_test(Pain ~ factor(Carrying))) \%>\%
        pool_levenetest(method="D1")

# Same as
imp_dat <- df2milist(lbpmilr, impvar="Impnr")
ra <- with(imp_dat, expr=levene_test(Pain ~ factor(Carrying)))
res <- pool_levenetest(ra, method="D1")

}
\references{
Eekhout I, van de Wiel MA, Heymans MW. Methods for significance testing of categorical
covariates in logistic regression models after multiple imputation: power and applicability
analysis. BMC Med Res Methodol. 2017;17(1):129.

Enders CK (2010). Applied missing data analysis. New York: The Guilford Press.

Van Buuren S. (2018). Flexible Imputation of Missing Data. 2nd Edition. Chapman & Hall/CRC
Interdisciplinary Statistics. Boca Raton.
}
\seealso{
\code{\link{with.milist}}, \code{\link{levene_test}}
}
\author{
Martijn Heymans, 2021
}
