% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_test.R
\name{t_test}
\alias{t_test}
\title{Calculates the one, two and paired sample t-test}
\usage{
t_test(y, x, formula, data, paired = FALSE, var_equal = TRUE)
}
\arguments{
\item{y}{numeric response variable.}

\item{x}{categorical variable with 2 groups.}

\item{formula}{A formula object to specify the model as normally
used by glm.}

\item{data}{An objects of class \code{milist}, created by
\code{df2milist}, \code{list2milist} or \code{mids2milist}.}

\item{paired}{a logical indicating whether you want
a paired t-test (TRUE) or not (FALSE, default).}

\item{var_equal}{a logical, if TRUE equal variances are assumed, if FALSE
(default) equal variances are not assumed and Welch correction
is applied for the number of degrees of freedom. See detail.}
}
\value{
An object containing the following objects are extracted:
\itemize{
\item  \code{mdiff} the mean difference.
\item  \code{se} the standard error.
\item  \code{dfcom} the complete data degrees of freedom.
}
}
\description{
\code{t_test} Calculates the one, two and paired sample t-test.
}
\details{
For all t-tests the dataset must be in long format
(i.e. group data under each other). For the paired t-test x and y
must have the same length. When variances between groups are
unequal, the Welch df correction formula is used and eventually
averaged across multiply imputed datasets in the \code{pool_t_test}
function.
}
\examples{

imp_dat <- df2milist(lbpmilr, impvar="Impnr")
ra <- with(imp_dat, expr=t_test(Pain ~ Gender))

}
\seealso{
\code{\link{with.milist}}, \code{\link{pool_t_test}}
}
\author{
Martijn Heymans, 2022
}
