% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dis_hwl.R
\encoding{UTF-8}
\name{dis_hwl}
\alias{dis_hwl}
\title{Constructs a pairwise distance matrix based on feature extraction}
\usage{
dis_hwl(X, features = FALSE)
}
\arguments{
\item{X}{A list of MTS (numerical matrices).}

\item{features}{Logical. If \code{features = FALSE} (default), a distance matrix is returned. Otherwise, the function
returns a dataset of feature vectors.}
}
\value{
If \code{features = FALSE} (default), returns a distance matrix based on the distance \eqn{d_{HWL}}. Otherwise, the function
returns a dataset of feature vectors, i.e., each row in the dataset contains the features employed to compute the
distance \eqn{d_{HWL}}.
}
\description{
\code{dis_hwl} returns a pairwise distance matrix based on the feature
extraction procedure proposed by \insertCite{hyndman2015large;textual}{mlmts}.
}
\details{
Given a collection of MTS, the function returns the pairwise distance matrix,
where the distance between two MTS is defined as the Euclidean distance
between the corresponding feature vectors
}
\examples{
toy_dataset <- AtrialFibrillation$data[1 : 10] # Selecting the first 10 MTS from the
# dataset AtrialFibrillation
distance_matrix <- dis_hwl(toy_dataset) # Computing the pairwise
# distance matrix based on the distance dis_hwl
#' feature_dataset <- dis_hwl(toy_dataset, features = TRUE) # Computing
# the corresponding dataset of features
}
\references{
{

  \insertRef{hyndman2015large}{mlmts}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
