% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reports.R
\name{report_modelcard}
\alias{report_modelcard}
\title{Create a Modelcard}
\usage{
report_modelcard(filename = "modelcard.Rmd", edit = FALSE, build = FALSE)
}
\arguments{
\item{filename}{(\code{character(1)})\cr
File path or name for new file that should be created.}

\item{edit}{(\code{logical(1)})\cr
\code{TRUE} to edit the template immediately.}

\item{build}{(\code{logical(1)})\cr
Should the report be built after creation? Initialized to \code{FALSE}.}
}
\value{
Invisibly returns the path to the newly created file(s).
}
\description{
Creates a new \CRANpkg{rmarkdown} template with a skeleton questionnaire for a model card.
Uses the awesome markdown template created by Chris Garbin
\href{https://github.com/fau-masters-collected-works-cgarbin/model-card-template}{from Github}.
}
\examples{
\dontshow{if (rlang::is_installed("rmarkdown")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
  report_file = tempfile()
  report_modelcard(report_file)
\dontshow{\}) # examplesIf}
}
\references{
Mitchell, Margaret, Wu, Simone, Zaldivar, Andrew, Barnes, Parker, Vasserman, Lucy, Hutchinson, Ben, Spitzer, Elena, Raji, Deborah I, Gebru, Timnit (2019).
\dQuote{Model cards for model reporting.}
In \emph{Proceedings of the conference on fairness, accountability, and transparency}, 220--229.
}
\seealso{
Other fairness_reports: 
\code{\link{report_datasheet}()},
\code{\link{report_fairness}()}
}
\concept{fairness_reports}
