% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priorPosterior.R
\name{PriorPosterior}
\alias{PriorPosterior}
\alias{priorPosterior}
\alias{priorPosterior.SurvFit}
\title{Return Prior and Posterior density of parameters of \code{SurvFit} object}
\usage{
priorPosterior(fit, ...)

\method{priorPosterior}{SurvFit}(fit, ...)
}
\arguments{
\item{fit}{An object of class \code{SurvFit}}

\item{\dots}{Further arguments to be passed to generic methods}
}
\value{
a plot of class \code{ggplot}
}
\description{
This is the generic \code{pp} S3 method for the \code{survFitTT} class. It
plots the predicted values with 95 \\% credible intervals versus the observed
values for \code{SurvFit} objects.

The coordinates of black points are the observed values of the number of survivors
(pooled replicates) for a given concentration (\eqn{X}-axis) and the corresponding
predicted values (\eqn{Y}-axis). 95\\% prediction intervals are added to each predicted
value, colored in green if this interval contains the observed value and in red
otherwise.
The bisecting line (y = x) is added to the plot in order to see if each
prediction interval contains each observed value. As replicates are shifted
on the x-axis, this line is represented by steps.
}
