test_that("lcx", {
    # LONG TO COMPUTE AND/OR INPUT FILE NOT STORED FOR CRAN
    # 'skip_on_cran: files not in fixtures because of size > 1MB'
    testthat::skip_on_cran()
    cPRZ_ITfit <- readRDS(test_path("fixtures", "cPRZ_ITfit.rds"))
    cPRZ_SDfit <- readRDS(test_path("fixtures", "cPRZ_SDfit.rds"))
    vPRZ_ITfit <- readRDS(test_path("fixtures", "vPRZ_ITfit.rds"))
    vPRZ_SDfit <- readRDS(test_path("fixtures", "vPRZ_SDfit.rds"))

    expect_no_error({
        cPRZ_ITlcxt <- lcxt(cPRZ_ITfit)
        cPRZ_SDlcxt <- lcxt(cPRZ_SDfit)
        vPRZ_ITlcxt <- lcxt(vPRZ_ITfit)
        vPRZ_SDlcxt <- lcxt(vPRZ_SDfit)
    })
    cPRZ_ITlcxt <- readRDS(test_path("fixtures", "cPRZ_ITlcxt.rds"))
    cPRZ_SDlcxt <- readRDS(test_path("fixtures", "cPRZ_SDlcxt.rds"))
    vPRZ_ITlcxt <- readRDS(test_path("fixtures", "vPRZ_ITlcxt.rds"))
    vPRZ_SDlcxt <- readRDS(test_path("fixtures", "vPRZ_SDlcxt.rds"))
    
    expect_no_error({
        plot(cPRZ_ITlcxt)
        plot(cPRZ_SDlcxt)
        plot(vPRZ_ITlcxt)
        plot(vPRZ_SDlcxt)
    })
    
    expect_no_error({
        plot(cPRZ_ITlcxt)
        plot(cPRZ_SDlcxt)
        plot(vPRZ_ITlcxt)
        plot(vPRZ_SDlcxt)
    })
})
test_that("lcx exposure", {
    # LONG TO COMPUTE AND/OR INPUT FILE NOT STORED FOR CRAN
    # 'skip_on_cran: files not in fixtures because of size > 1MB'
    testthat::skip_on_cran()
    cPRZ_ITfit <- readRDS(test_path("fixtures", "cPRZ_ITfit.rds"))
    cPRZ_SDfit <- readRDS(test_path("fixtures", "cPRZ_SDfit.rds"))
    vPRZ_ITfit <- readRDS(test_path("fixtures", "vPRZ_ITfit.rds"))
    vPRZ_SDfit <- readRDS(test_path("fixtures", "vPRZ_SDfit.rds"))
    
    expect_no_error({
        cPRZ_ITlcxt_x100 <- lcxt(cPRZ_ITfit, exposure_range = c(0, 100))
        cPRZ_ITlcxt_x52 <- lcxt(cPRZ_ITfit, exposure_range = c(0, 52))
    })
    
    expect_no_error({
        plot(cPRZ_ITlcxt_x100)
        plot(cPRZ_ITlcxt_x52)
    })
    
})