% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mplot-package.R
\docType{data}
\name{wallabies}
\alias{wallabies}
\title{Rock-wallabies data set}
\format{
A data frame with 200 observations on 9 variables.
\describe{
\item{rw}{Presence of rock-wallaby scat}
\item{edible}{Percentage cover of edible vegetation}
\item{inedible}{Percentage cover of inedible vegetation}
\item{canopy}{Percentage canopy cover}
\item{distance}{Distance from diurnal refuge}
\item{shelter}{Whether or not a plot occurred within a shelter point (large
rock or boulder pile)}
\item{lat}{Latitude of the plot location}
\item{long}{Longitude of the plot location}
}
}
\usage{
data(wallabies)
}
\description{
On Chalkers Top in the Warrumbungles (NSW, Australia) 200 evenly distributed
one metre squared plots were surveyed. Plots were placed at a density
of 7-13 per hectare. The presence or absence of fresh
(<1 month old) scats of rock-wallabies was recorded for each plot
along with location and a selection of predictor variables.
}
\details{
Macropods defaecate randomly as they forage and scat
(faecal pellet) surveys are a reliable method for detecting the
presence of rock-wallabies and other macropods.
Scats are used as an indication of spatial foraging patterns
of rock-wallabies and sympatric macropods. Scats deposited while
foraging were not confused with scats deposited while
resting because the daytime refuge areas of rock-wallabies
were known in detail for each colony and no samples were
taken from those areas. Each of the 200 sites were
examined separately to
account for the different levels of predation risk and the
abundance of rock-wallabies.
}
\examples{
data(wallabies)
wdat = data.frame(subset(wallabies,select=-c(lat,long)), 
  EaD = wallabies$edible*wallabies$distance,
  EaS = wallabies$edible*wallabies$shelter,
  DaS = wallabies$distance*wallabies$shelter)
M1 = glm(rw~., family = binomial(link = "logit"), data = wdat)
}
\references{
Tuft KD, Crowther MS, Connell K, Mueller S and McArthur C (2011),
Predation risk and competitive interactions affect foraging of
an endangered refuge-dependent herbivore. Animal Conservation,
14: 447-457. doi: 10.1111/j.1469-1795.2011.00446.x
}
\keyword{datasets}
