% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrPdPlotBootstrap.R
\name{mrPdPlotBootstrap}
\alias{mrPdPlotBootstrap}
\title{Bootstrap Partial Dependence Plots}
\usage{
mrPdPlotBootstrap(
  mrIML_obj,
  mrBootstrap_obj,
  vi_obj = NULL,
  target,
  global_top_var = 2
)
}
\arguments{
\item{mrIML_obj}{A list object returned by \code{\link[=mrIMLpredicts]{mrIMLpredicts()}}.}

\item{mrBootstrap_obj}{A list object returned by \code{\link[=mrBootstrap]{mrBootstrap()}}.}

\item{vi_obj}{A list object returned by \code{\link[=mrVip]{mrVip()}}. If \code{vi_obj} is not
provided, then it is created inside \code{mrPD_bootstrap} by running \code{\link[=mrVip]{mrVip()}}.}

\item{target}{The target variable for generating plots.}

\item{global_top_var}{The number of top variables to consider (default: 2).}
}
\value{
A list with two elements:
\itemize{
\item \verb{[[1]]}: A data frame of the partial dependence grid for each response model,
predictor variable, and bootstrap.
\item \verb{[[2]]}: A list of partial dependence plots for each predictor variable in
the \code{target} response model.
}
}
\description{
This function extracts and plots the bootrapped partial dependence functions
calculated by \code{\link[=mrBootstrap]{mrBootstrap()}} for each response variable.
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mrIML_rf <- mrIML::mrIML_bird_parasites_RF

mrIML_rf_boot <- mrIML_rf \%>\%
  mrBootstrap(num_bootstrap = 50)

mrIML_rf_PD <- mrPdPlotBootstrap(
  mrIML_rf,
  mrIML_rf_boot,
  target = "Plas",
  global_top_var = 4
)

head(mrIML_rf_PD[[1]])
mrIML_rf_PD[[2]]
\dontshow{\}) # examplesIf}
}
