% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textaInit.R
\name{textaInit}
\alias{textaInit}
\title{Initializes the \pkg{mscstexta4r} package.}
\usage{
textaInit()
}
\description{
This function initializes the Microsoft Cognitive Services
Text Analytics REST API key and URL by reading them either from a
configuration file or environment variables.

This function \strong{MUST} be called right after package load and before calling
any \pkg{mscstexta4r} core functions, or these functions will fail.

The \code{\link{textaInit}} configuration function will first check to see
if the variable \code{MSCS_TEXTANALYTICS_CONFIG_FILE} exists in the system
environment. If it does, the package will use that as the path to the
configuration file.

If \code{MSCS_TEXTANALYTICS_CONFIG_FILE} doesn't exist, it will look for
the file \code{.mscskeys.json} in the current user's home directory (that's
\code{~/.mscskeys.json} on Linux, and something like \code{C:/Users/Phil/Documents/.mscskeys.json}
on Windows). If the file is found, the package will load the API key and URL
from it.

If using a file, please make sure it has the following structure:

\preformatted{
{
  "textanalyticsurl": "https://westus.api.cognitive.microsoft.com/texta/analytics/v2.0/",
  "textanalyticskey": "...MSCS Text Analytics API key goes here..."
}
}

If no configuration file is found, \code{\link{textaInit}} will attempt to
pick up its configuration information from two Sys env variables instead:

\code{MSCS_TEXTANALYTICS_URL} - the URL for the Text Analytics REST API.

\code{MSCS_TEXTANALYTICS_KEY} -  your personal Text Analytics REST API key.

\code{\link{textaInit}} needs to be called \emph{only once}, after package
load.
}
\examples{
\dontrun{
 textaInit()
}
}
\author{
Phil Ferriere \email{pferriere@hotmail.com}
}

