% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linegraph.R
\name{linegraph}
\alias{linegraph}
\title{Line graph showing the results of \code{\link{mtrank}} across different
smallest worthwhile difference (SWD) values}
\usage{
linegraph(
  x,
  swd,
  swd.ref,
  small.values = x$small.values,
  type = "probability",
  k = length(x$trts),
  backtransf = FALSE,
  linewidth = 1.1,
  point.size = 2,
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link{mtrank}}.}

\item{swd}{A numeric vector of SWD values to be used for the sensitivity
analysis.}

\item{swd.ref}{A numeric SWD value to be used as the reference for sorting
treatments in the final graph. This value must be included in
\code{swd}.}

\item{small.values}{A character string specifying whether small treatment
effects indicate a beneficial (\code{"desirable"}) or harmful
(\code{"undesirable"}) effect; can be abbreviated.}

\item{type}{The metric to be used for plotting the results of the
sensitivity analysis. Two options are available: the default is
\code{"probability"}, which plots results in terms of normalized abilities; 
the alternative is \code{"ability"}, which plots results in terms of
ability estimates. Both options can be abbreviated.}

\item{k}{A numeric value indicating the number of treatments to be plotted.
By default, all available treatments are shown. For large networks, it is
advisable to limit the number of treatments to improve readability.
If specified, the first \code{k} treatments based on the hierarchy at
\code{swd.ref} will be plotted.}

\item{backtransf}{A logical value indicating whether to display log-ability
estimates (\code{FALSE}, default) or back-transformed ability estimates
on the natural scale (\code{TRUE}). This argument is ignored if
\code{type = "probability"}.}

\item{linewidth}{A numeric value specifying the width of the lines
(default: 1.1).}

\item{point.size}{A numeric value specifying the size of the points
(default: 2).}

\item{\dots}{Additional arguments passed to \code{\link[mtrank]{mtrank}}.}
}
\value{
A \code{ggplot} object.
}
\description{
This function produces a line graph that visualizes the results of
\code{\link{mtrank}} in terms of either abilities or probabilities across
different smallest worthwhile difference (SWD) values.
}
\details{
This function creates a line graph to visualize probability or ability
estimates obtained from \code{\link{mtrank}} across different SWD values.
The order of treatments in the graph is based on their hierarchy at the
reference SWD value (\code{swd.ref}).
}
\examples{
data("antidepressants")
#
pw <- pairwise(studlab = studyid, treat = drug_name,
  n = ntotal, event = responders,
  data = antidepressants, sm = "OR")
# Use subset to reduce runtime
pw <- subset(pw, studyid < 60)
#
net <- netmeta(pw, reference.group = "tra")
#
ranks <- tcc(net, swd = 1.20, small.values = "undesirable")
#
fit <- mtrank(ranks)
#
# Perform a sensitivity analysis across different SWD values assuming that
# 1.20 is the reference value
swd.vec <- seq(1.10, 1.50, by = 0.10)
swd.ref <- 1.20
# plot all the treatments in the network
linegraph(fit, swd = swd.vec, swd.ref = swd.ref)
\donttest{
# plot only the first three treatments in the order appearing at the
# 'swd.ref' value
linegraph(fit, swd = swd.vec, swd.ref = swd.ref, k = 3)
# plot in terms of ability estimates 
linegraph(fit, swd = swd.vec, swd.ref = swd.ref, type = "ability")
}
  
}
\references{
Evrenoglou T, Nikolakopoulou A, Schwarzer G, Ruecker G, Chaimani A (2024):
Producing treatment hierarchies in network meta-analysis using probabilistic
models and treatment-choice criteria,
\url{https://arxiv.org/abs/2406.10612}
}
