% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_0_ENV.R
\name{estimate_0_ENV}
\alias{estimate_0_ENV}
\title{Tool for Generating an Environment for Models}
\usage{
estimate_0_ENV(
  data,
  colnames = list(),
  behrule,
  funcs = list(),
  priors = list(),
  settings = list(),
  ...
)
}
\arguments{
\item{data}{A data frame in which each row represents a single trial,
see \link[multiRL]{data}}

\item{colnames}{Column names in the data frame,
see \link[multiRL]{colnames}}

\item{behrule}{The agent’s implicitly formed internal rule,
see \link[multiRL]{behrule}}

\item{funcs}{The functions forming the reinforcement learning model,
see \link[multiRL]{funcs}}

\item{priors}{Prior probability density function of the free parameters,
see \link[multiRL]{priors}}

\item{settings}{Other model settings, 
see \link[multiRL]{settings}}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
An \code{environment}, \code{multiRL.env} contains all variables 
   required by the objective function and is used to isolate environments 
   during parallel computation.
}
\description{
This function creates an independent R environment for each model (or 
   object function) when searching for optimal parameters using an algorithm 
   package. Such isolation is especially important when parameter 
   optimization is performed in parallel across multiple subjects. The 
   function transfers standardized input parameters into a dedicated 
   environment, ensuring that each model is evaluated in a self-contained 
   and interference-free context.
}
