% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_generic_conservation_test.R
\name{diagnose_test_robustness}
\alias{diagnose_test_robustness}
\title{Diagnose Test Robustness}
\usage{
diagnose_test_robustness(
  test,
  phyex_set,
  sample_sizes = c(500, 1000, 5000, 10000),
  plot_result = TRUE,
  num_reps = 5,
  ...
)
}
\arguments{
\item{test}{Function representing the conservation test to evaluate}

\item{phyex_set}{A PhyloExpressionSet object}

\item{sample_sizes}{Numeric vector of sample sizes to test (default: c(500, 1000, 5000, 10000))}

\item{plot_result}{Logical indicating whether to plot results (default: TRUE)}

\item{num_reps}{Number of replicates for each sample size (default: 5)}

\item{...}{Additional arguments passed to the test function}
}
\value{
A data frame with test results across different sample sizes
}
\description{
Evaluate the robustness of conservation tests across different sample sizes
for null distribution generation.
}
\details{
This function assesses how consistent test results are across different sample sizes
for null distribution generation, helping to determine appropriate sample sizes
for reliable testing.
}
\examples{
# Diagnose flatline test robustness
robustness <- diagnose_test_robustness(stat_flatline_test, 
                                       example_phyex_set,
                                       sample_sizes=c(10,20),
                                       plot_result=FALSE,
                                       num_reps=3)

}
