% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Updating_rule.R
\name{updating}
\alias{updating}
\title{Updating rules}
\usage{
updating(likelihood, states, q, r_q, beta, eta)
}
\arguments{
\item{likelihood}{A vector of the likelihood distribution on the states in the structure.}

\item{states}{A state-by-problem matrix representing the structure, where an element is one if the item is included in the state, and zero otherwise.}

\item{q}{Last administered item}

\item{r_q}{Observed response to item q}

\item{beta}{Vector of careless error probabilities}

\item{eta}{Vector of lucky guess error probabilities}
}
\value{
The updated likelihood distribution on the knowledge states
}
\description{
Multiplicative rule as in Falmagne and Doignon 2010 (Chapter 13, Section 10)
}
\examples{
# Let consider the knowledge space and the parameters used in Brancaccio,
# de Chiusole, Stefanutti (2023) in Example 1

states<-matrix(c( 0,0,0,0,0,
                   0,0,0,0,1,
                   0,0,1,0,1,
                   0,0,0,1,1,
                   0,0,1,1,1,
                   1,0,1,0,1,
                   0,1,0,1,1,
                   1,0,1,1,1,
                   0,1,1,1,1,
                   1,1,0,1,1,
                   1,1,1,1,1), byrow=TRUE, ncol=5)
beta  <-c(.004,.03,.02,.01,.007)
eta   <-c(5e-06, 5e-05, 4e-05,.007,.08)
likelihood_0 <-rep(1,nrow(states))/nrow(states)
# Item asked
q = 3
# response observed
r_q = 1
likelihood_1 <- updating(likelihood_0,states,q,r_q,beta,eta)
}
