% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_ic50.R
\name{predict_ic50}
\alias{predict_ic50}
\title{Predict the IC50 for peptides.}
\usage{
predict_ic50(
  peptides,
  mhc_haplotype,
  netmhc2pan_folder_name = get_default_netmhc2pan_folder(),
  temp_fasta_filename = netmhc2pan::create_temp_fasta_filename(),
  temp_xls_filename = netmhc2pan::create_temp_xls_filename()
)
}
\arguments{
\item{peptides}{one or more peptide sequences}

\item{mhc_haplotype}{one MHC haplotype, e.g. \code{DRB1_0101}.
See \link{get_netmhc2pan_alleles} for a full list}

\item{netmhc2pan_folder_name}{the folder (to be) used by NetMHCIIpan.
From this location, a subfolder for NetMHCIIpan is created.
Use \link{get_default_netmhc2pan_folder} to see the location
of the default NetMHCIIpan folder.
Use \link{get_default_netmhc2pan_subfolder} to see the location
of the default NetMHCIIpan subfolder.}

\item{temp_fasta_filename}{name for a temporary FASTA file,
which will be deleted automatically}

\item{temp_xls_filename}{name for a temporary \code{xls} file,
which will be deleted automatically}
}
\value{
a \link[tibble]{tibble} with two columns:
(1) \code{peptide}, which holds the peptide sequence, and
(2) \code{ic50}, which holds the predicted IC50
}
\description{
Predict the half maximal inhibitory concentration (aka IC50) (in nM)
for one or more peptides, where the peptides are used as-is,
instead of split into smaller peptides.
Each peptide must be 15 amino acids at
most (use \link{predict_ic50s} to predict the IC50s for longer peptides)
}
\note{
this function uses a temporary file, because NetMHC2pan reads its
input from file. This temporary file is deleted after this function
passed successfully.
}
\examples{
if (is_netmhc2pan_installed()) {

  predict_ic50(
    peptides = c("AIAACAMLLV", "ALVCYIVMPV"),
    mhc_haplotype = "DRB1_0416"
  )
}
}
\author{
Richèl J.C. Bilderbeek
}
