% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/simplex.R
\docType{methods}
\name{arithmetic}
\alias{arithmetic}
\alias{\%perturbe\%}
\alias{`\%perturbe\%`-method}
\alias{\%power\%}
\alias{`\%power\%`-method}
\alias{\%perturbe\%,CompositionMatrix,CompositionMatrix-method}
\alias{`\%perturbe\%`,CompositionMatrix,CompositionMatrix-method}
\alias{\%power\%,CompositionMatrix,numeric-method}
\alias{`\%power\%`,CompositionMatrix,numeric-method}
\alias{\%power\%,numeric,CompositionMatrix-method}
\alias{`\%power\%`,numeric,CompositionMatrix-method}
\title{Operations in the Simplex}
\usage{
x \%perturbe\% y

x \%power\% y

\S4method{\%perturbe\%}{CompositionMatrix,CompositionMatrix}(x, y)

\S4method{\%power\%}{CompositionMatrix,numeric}(x, y)

\S4method{\%power\%}{numeric,CompositionMatrix}(x, y)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{y}{A \code{\linkS4class{CompositionMatrix}} object or a \code{\link{numeric}} vector.}
}
\value{
A \code{\linkS4class{CompositionMatrix}} object or a \code{\link{numeric}} vector (same as \code{x}).
}
\description{
Operators performing operations in the simplex.
}
\details{
\describe{
\item{\verb{\%perturbe\%}}{\link[=perturbation]{Perturbation operation}.}
\item{\verb{\%power\%}}{\link[=powering]{Powering operation}.}
}
}
\examples{
x <- as_composition(c(1, 2, 3))
y <- as_composition(c(1, 2, 1))

## Perturbation
perturbation(x, y)
x + y

## Powering
powering(y, 2)
y * 2

## Scalar product
scalar(x, y)
}
\seealso{
Other operations in the simplex: 
\code{\link{closure}()},
\code{\link{perturbation}()},
\code{\link{powering}()},
\code{\link{scalar}()}
}
\author{
N. Frerebeau
}
\concept{operations in the simplex}
