% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSharm.R
\name{SSharm1}
\alias{SSharm1}
\alias{harm1}
\title{self start for a harmonic regression model}
\usage{
harm1(x, b0, b1, cos1, sin1)

SSharm1(x, b0, b1, cos1, sin1)
}
\arguments{
\item{x}{input vector}

\item{b0}{intercept of the harmonic regression}

\item{b1}{slope of the harmonic regression}

\item{cos1}{coefficient associated with the cosine of the harmonic regression}

\item{sin1}{coefficient associated with the sine of the harmonic regression}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

harm1: vector of the same length as x using a harmonic regression
}
\description{
Self starter for a harmonic regression
}
\details{
Harmonic regression is actually a type of linear regression. Just adding it for convenience.
}
\examples{
\donttest{
require(ggplot2)
set.seed(1234)
x <- seq(0, 3, length.out = 100)
y <- harm1(x, 0, 0, 0.05, 0) + rnorm(length(x), 0, 0.002)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSharm1(x, b0, b1, cos1, sin1), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
}
}
