% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-functions_relabund.R
\name{nmr_relabund}
\alias{nmr_relabund}
\title{Compute relative abundance for each sample}
\usage{
nmr_relabund(dat, method)
}
\arguments{
\item{dat}{Processed spectral data, output from (a) \code{\link{nmr_import_spectra}}
and \code{\link{nmr_assign_bins}}; or (b) \code{\link{nmr_import_peaks}}}

\item{method}{The method for calculating relative abundance.
Options include (a) "AUC", integrating the spectral region within each bin;
(b) "peaks", adding areas of peaks if a peak-picked file is provided.}
}
\value{
A \code{\link{data.frame}} with columns describing relative contributions of
compound classes. Compound classes are determined by selecting the desired
binset.
}
\description{
Compute relative abundance of compound classes for each sample.
}
\examples{
sdir <- system.file("extdata", "kfp_hysteresis", "peaks_mnova_multiple", package = "nmrrr")
peaks <- nmr_import_peaks(path = sdir, method = "multiple columns")
peaks <- nmr_assign_bins(peaks, bins_Clemente2012)
nmr_relabund(peaks, "peaks")
}
\author{
Kaizad Patel
}
