% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{NSBMtest}
\alias{NSBMtest}
\title{NoisySBM for test}
\format{
\describe{
\item{\code{dataMatrix}}{A square matrix containing the observation of the graph}
\item{\code{theta}}{True NSBM parameters}
\item{\code{latentZ}}{True latent clustering}
\item{\code{latentAdj}}{True latent adjacency matrix}
}
}
\usage{
NSBMtest
}
\description{
Example of NoisySBM data
}
\examples{
main_noisySBM(NSBMtest$dataMatrix,NIG=TRUE,Qup=10,nbOfZ=1,nbCores=1)

#Note : These data were created using the following instructions
p=50
Q=6
pi=c(1/6,1/6,1/6,1/6,1/6,1/6)
w=c(0.811,0.001,0.001,0.001,0.001,0.001,0.811,0.011,0.001,0.001,0.001,
0.811,0.001,0.001,0.001,0.811,0.001,0.001,0.811,0.011,0.811)
theta=list(pi=pi,w=w,nu0=c(0,1))
theta$nu <- array(0, dim = c(Q*(Q+1)/2, 2))
theta$nu[,1] <- rep(2,21)
theta$nu[,2] <- rep(2,21)
NSBMtest=rnsbm(p,theta)

}
\keyword{datasets}
