% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_extract.R
\name{nest_extract}
\alias{nest_extract}
\title{Extract a character column into multiple columns using regex groups in a column of nested data frames}
\usage{
nest_extract(
  .data,
  .nest_data,
  col,
  into,
  regex = "([[:alnum:]]+)",
  remove = TRUE,
  convert = FALSE,
  ...
)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g., a tibble), or a lazy
data frame (e.g., from dbplyr or dtplyr).}

\item{.nest_data}{A list-column containing data frames}

\item{col}{Column name or position within \code{.nest_data} (must be present within
all nested data frames in \code{.nest_data}). This is passed to \code{tidyselect::vars_pull()}.

This argument is passed by expression and supports quasiquotation (you can
unquote column names or column positions).}

\item{into}{Names of new variables to create as character vector.
Use \code{NA} to omit the variable in the output.}

\item{regex}{A string representing a regular expression used to extract the
desired values. There should be one group (defined by \verb{()}) for each
element of \code{into}.}

\item{remove}{If \code{TRUE}, remove input column from output data frame.}

\item{convert}{If \code{TRUE}, will run \code{\link[=type.convert]{type.convert()}} with
\code{as.is = TRUE} on new columns. This is useful if the component
columns are integer, numeric or logical.

NB: this will cause string \code{"NA"}s to be converted to \code{NA}s.}

\item{...}{Additional arguments passed on to \code{\link[tidyr:extract]{tidyr::extract()}} methods.}
}
\value{
An object of the same type as \code{.data}. Each object in the column \code{.nest_data}
will have new columns created according to the capture groups specified in
the regular expression.
}
\description{
\code{nest_extract()} is used to extract capturing groups from a column in a nested
data frame using regular expressions into a new column. If the groups don't
match, or the input is NA, the output will be NA.
}
\details{
\code{nest_extract()} is a wrapper for \code{\link[tidyr:extract]{tidyr::extract()}} and maintains the functionality
of \code{extract()} within each nested data frame. For more information on \code{extract()}
please refer to the documentation in \href{https://tidyr.tidyverse.org/}{'tidyr'}.
}
\examples{
set.seed(123)
gm <- gapminder::gapminder 

gm <- 
  gm \%>\% 
  dplyr::mutate(comb = sample(c(NA, "a-b", "a-d", "b-c", "d-e"),
                              size = nrow(gm),
                              replace = TRUE))
                              
gm_nest <- gm \%>\% tidyr::nest(country_data = -continent)

gm_nest \%>\% 
  nest_extract(country_data,
               col = comb,
               into = c("var1","var2"),
               regex = "([[:alnum:]]+)-([[:alnum:]]+)")
}
\seealso{
Other tidyr verbs: 
\code{\link{nest_drop_na}()},
\code{\link{nest_fill}()},
\code{\link{nest_replace_na}()},
\code{\link{nest_separate}()},
\code{\link{nest_unite}()}
}
\concept{tidyr verbs}
