% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds_test.R
\name{mds_test}
\alias{mds_test}
\title{Test optimal number of MDS dimensions.}
\usage{
mds_test(
  dissimilarity_matrix,
  n_boots = 50,
  n_perms = 50,
  test_dimensions = 5,
  principal = TRUE,
  mds_type = "ordinal",
  spline_degree = 2,
  spline_int_knots = 2,
  ...
)
}
\arguments{
\item{dissimilarity_matrix}{Square matrix of dissimilarity scores.}

\item{n_boots}{Number of bootstrapping iterations (default: 25).}

\item{n_perms}{Number of permutations (default: 25).}

\item{test_dimensions}{Number of MDS dimensions to test for stress reduction (default: 5).}

\item{principal}{Whether to apply principal axis transform to MDS (default: TRUE)}

\item{mds_type}{What kind of MDS to apply, see \code{\link[smacof:smacofSym]{smacof::smacofSym()}} (default: 'ordinal')}

\item{spline_degree}{How many spline degrees when \code{type} is 'mspline' (default: 2)}

\item{spline_int_knots}{How many internal knots when \code{type} is 'mspline' (default: 2)}

\item{...}{Arguments passed to \code{\link[smacof:smacofSym]{smacof::smacofSym()}}}
}
\value{
object of class \code{mds_test_results}, containing:
\itemize{
\item \verb{$stress_reduction} a tibble containing
\item \verb{$n_boots} Number of bootstrapping iterations.
\item \verb{$n_perms} Number of permutation iterations
\item \verb{$mds_type} Type of MDS analysis (\code{type} argument passed to
\code{\link[smacof:smacofSym]{smacof::smacofSym()}})
\item \verb{$principal} Whether principal axis transformation is applied (passed to
\code{\link[smacof:smacofSym]{smacof::smacofSym()}})
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Generate bootstrapped confidence intervals and permutation based null
distribution for MDS analysis. Output shows how much stress is reduced by
adding an additional dimension to the MDS analysis of \code{dissimilarity_matrix},
and bootstrapped iterations of \code{dissimilarity_matrix},
compared with the stress reduction expected from a matrix with no meaningful
structure. This function is inspired by \code{\link[=pca_test]{pca_test()}}, but is less connected
with statistical literature than that function. We currently reject
additional dimensions is they reduce less stress than we would expect by
chance. That is, when the distribution from the boostrapped analyses sits
notably lower than the permuted distribution when plotted by \code{\link[=plot_mds_test]{plot_mds_test()}}
}
\examples{
# Apply interval MDS to `sim_matrix`, with 5 permutations and bootstraps
# testing up to 3 dimensions. In real usage, increase `n_boots` and `n_perms`
# to at least 50.
mds_test(
 smacof::sim2diss(sim_matrix, method="reverse"),
 n_boots = 5,
 n_perms = 5,
 test_dimensions = 3,
 mds_type = 'interval'
)

}
