% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pc_flip.R
\name{pc_flip}
\alias{pc_flip}
\title{Flip PC loadings}
\usage{
pc_flip(pca_obj, pc_no, flip_var = NULL)
}
\arguments{
\item{pca_obj}{The result of a call to \code{prcomp()}, \code{princomp()} or \code{pca_test}.}

\item{pc_no}{An integer, indicating which PC is to be flipped.}

\item{flip_var}{An optional name of a variable which will become positive
in the PC indicated by \code{pc_no}.}
}
\value{
An object matching the class of \code{pca_obj} with relevant PC modified.
}
\description{
The sign of the loadings and scores generated by PCA is arbitrary. Sometimes
it is convenient to flip them so that all positive loadings/scores become
negative (and vice versa). Sometimes one direction leads to a more natural
interpretation. It is also useful when comparing the results of PCA across
multiple data sets. This function will flip loadings and scores for PCA
analyses carried out by the base R \code{\link[=prcomp]{prcomp()}} and \code{\link[=princomp]{princomp()}} functions and
for the \code{\link[=pca_test]{pca_test()}} function from this package. If you specify only \code{pc_no}
you will flip the loadings and scores for that PC. You can also specify a
variable which you would like to have a positive loading in the resulting
PCA.
}
\examples{
  pca_obj <- prcomp(onze_intercepts |> dplyr::select(-speaker), scale=TRUE)

  # flip the second PC
  flipped_pca <- pc_flip(pca_obj, pc_no = 2)

  # flip (if necessary) the third PC, so that the "F1_GOOSE" variable has
  # a positive loading
  flipped_pca <- pc_flip(pca_obj, pc_no = 3, flip_var = "F1_GOOSE")
}
