% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_NOAA.R
\name{get_NOAA}
\alias{get_NOAA}
\alias{url_parser}
\title{Obtain NOAA World Ocean Atlas dataset}
\usage{
get_NOAA(var, spat_res, av_period, cache = FALSE)

url_parser(var, spat_res, av_period, cache = FALSE)
}
\arguments{
\item{var}{The chemical or physical variable of interest (possible choices:
\code{"temperature"}, \code{"phosphate"}, \code{"nitrate"}, \code{"silicate"}, \code{"oxygen"},
\code{"salinity"}, \code{"density"}).}

\item{spat_res}{Spatial resolution, either 1 or 5 degree grid-cells (numeric)
.}

\item{av_period}{Temporal resolution, either \code{"annual"}, specific seasons
(e.g. \code{"winter"}), or month (e.g. \code{"August"}).}

\item{cache}{Caching the extracted NOAA file in the package's \code{extdata}
directory (default = \code{FALSE}). Size of individual files is around 12 Mb. Use
\code{\link[=list_NOAA]{list_NOAA()}} to list cached data resources.}
}
\value{
\code{\link[stars:st_as_stars]{stars}} object or path.
}
\description{
Retrieves data from the NOAA World Ocean Atlas.
}
\details{
Functions to retrieve data from the
\href{https://www.ncei.noaa.gov/products/world-ocean-atlas}{NOAA World Ocean Atlas}
. Data is an 3D array (longitude, latitude, and depth) and is loaded as a
\code{\link[stars:st_as_stars]{stars}} object. Check \code{\link{NOAA_data}} for available
variables, respective units and their citations. The function can automatically
cache the extracted files (default: \code{cache = FALSE}). The cached file will
then reside in the package's \code{extdata} directory.
}
\examples{

# path to NOAA server or local data source
url_parser("oxygen", 1, "annual")

if (interactive()) {

# retrieve NOAA data
get_NOAA("oxygen", 1, "annual")

}
}
\seealso{
\href{https://r-spatial.github.io/stars/articles/stars1.html}{Introduction to the stars package}
}
