% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar_annulusMap.R
\name{annulusMap}
\alias{annulusMap}
\title{Polar annulus plots on dynamic and static maps}
\usage{
annulusMap(
  data,
  pollutant = NULL,
  period = "hour",
  limits = "free",
  latitude = NULL,
  longitude = NULL,
  crs = 4326,
  type = NULL,
  popup = NULL,
  label = NULL,
  provider = "OpenStreetMap",
  cols = "turbo",
  alpha = 1,
  key = FALSE,
  legend = TRUE,
  legend.position = NULL,
  legend.title = NULL,
  legend.title.autotext = TRUE,
  control.collapsed = FALSE,
  control.position = "topright",
  control.autotext = TRUE,
  d.icon = 200,
  d.fig = 3.5,
  static = FALSE,
  static.nrow = NULL,
  progress = TRUE,
  ...,
  control = NULL
)
}
\arguments{
\item{data}{\emph{Input data table with pollutant, wind, and geo-spatial
information.}

\strong{required} | \emph{scope:} dynamic & static

A data frame. The data frame must contain the data to plot the directional
analysis marker, which includes wind speed (\code{ws}), wind direction (\code{wd}),
and the column representing the concentration of a pollutant. In addition,
\code{data} must include a decimal latitude and longitude (or X/Y coordinate
used in conjunction with \code{crs}).}

\item{pollutant}{\emph{Pollutant name(s).}

\strong{required} | \emph{scope:} dynamic & static

The column name(s) of the pollutant(s) to plot. If multiple pollutants are
specified and a non-pairwise statistic is supplied, the \code{type} argument
will no longer be able to be used and:
\itemize{
\item \emph{Dynamic}: The pollutants can be toggled between using a "layer control" menu.
\item \emph{Static:}: The pollutants will each appear in a different panel.
}

Multiple \code{pollutants} prohibit the use of the \code{type} argument for
non-pairwise statistics.}

\item{period}{\emph{Temporal period for radial axis.}

\emph{default:} \code{"hour"} | \emph{scope:} dynamic & static

Options are "hour" (the default, to plot diurnal variations), "season" to
plot variation throughout the year, "weekday" to plot day of the week
variation and "trend" to plot the trend by wind direction.}

\item{limits}{\emph{Specifier for the plot colour scale bounds.}

\emph{default:} \code{"free"} | \emph{scope:} dynamic & static

One of:
\itemize{
\item \code{"fixed"} which ensures all of the markers use the same colour scale.
\item \code{"free"} (the default) which allows all of the markers to use different
colour scales.
\item A numeric vector in the form \code{c(lower, upper)} used to define the colour
scale. For example, \code{limits = c(0, 100)} would force the plot limits to
span 0-100.
}}

\item{latitude, longitude}{\emph{The decimal latitude(Y)/longitude(X).}

\emph{default:} \code{NULL} | \emph{scope:} dynamic & static

Column names representing the decimal latitude and longitude (or other Y/X
coordinate if using a different \code{crs}). If not provided, will be
automatically inferred from data by looking for a column named
"lat"/"latitude" or "lon"/"lng"/"long"/"longitude" (case-insensitively).}

\item{crs}{\emph{The coordinate reference system (CRS).}

\emph{default:} \code{4326} | \emph{scope:} dynamic & static

The coordinate reference system (CRS) of the data, passed to
\code{\link[sf:st_crs]{sf::st_crs()}}. By default this is \href{https://epsg.io/4326}{EPSG:4326}, the
CRS associated with the commonly used latitude and longitude coordinates.
Different coordinate systems can be specified using \code{crs} (e.g., \code{crs = 27700} for the \href{https://epsg.io/27700}{British National Grid}). Note that
non-lat/lng coordinate systems will be re-projected to EPSG:4326 for
plotting on the map.}

\item{type}{\emph{A method to condition the \code{data} for separate plotting.}

\emph{default:} \code{NULL} | \emph{scope:} dynamic & static

Used for splitting the input data into different groups, passed to the
\code{type} argument of \code{\link[openair:cutData]{openair::cutData()}}. When \code{type} is specified:
\itemize{
\item \emph{Dynamic}: The different data splits can be toggled between using a "layer control" menu.
\item \emph{Static:}: The data splits will each appear in a different panel.
}

\code{type} cannot be used if multiple \code{pollutant} columns have been provided.}

\item{popup}{\emph{Content for marker popups on dynamic maps.}

\emph{default:} \code{NULL} | \emph{scope:} dynamic

Columns to be used as the HTML content for marker popups on dynamic maps.
Popups may be useful to show information about the individual sites (e.g.,
site names, codes, types, etc.). If a vector of column names are provided
they are passed to \code{\link[=buildPopup]{buildPopup()}} using its default values.}

\item{label}{\emph{Content for marker hover-over on dynamic maps.}

\emph{default:} \code{NULL} | \emph{scope:} dynamic

Column to be used as the HTML content for hover-over labels. Labels are
useful for the same reasons as popups, though are typically shorter.}

\item{provider}{\emph{The basemap(s) to be used.}

\emph{default:} \code{"OpenStreetMap"} | \emph{scope:} dynamic & static

The base map(s) to be used beneath the polar markers. If not provided, will
default to \code{"OpenStreetMap"}/\code{"osm"} for both dynamic and static maps.
\itemize{
\item \emph{Dynamic}: Any number of \link[leaflet:providers]{leaflet::providers}.
See \url{http://leaflet-extras.github.io/leaflet-providers/preview/} for a list
of all base maps that can be used. If multiple base maps are provided, they
can be toggled between using a "layer control" interface. By default, the
interface will use the provider names as labels, but users can define their
own using a named vector (e.g., \code{c("Default" = "OpenStreetMap", "Satellite"   = "Esri.WorldImagery")})
\item \emph{Static}: One of \code{\link[rosm:deprecated]{rosm::osm.types()}}.
}

There is some overlap in static and dynamic providers. For example,
\code{{ggspatial}} uses "osm" to specify "OpenStreetMap". When static providers
are provided to dynamic maps or vice versa, \code{{openairmaps}} will attempt to
substitute the correct provider string.}

\item{cols}{\emph{Colours to use for plotting.}

\emph{default:} \code{"turbo"} | \emph{scope:} dynamic & static

The colours used for plotting, passed to \code{\link[openair:openColours]{openair::openColours()}}. The
default, \code{"turbo"}, is a rainbow palette with relatively perceptually
uniform colours. Read more about this palette at
\url{https://research.google/blog/turbo-an-improved-rainbow-colormap-for-visualization/}.}

\item{alpha}{\emph{Transparency value for polar markers.}

\emph{default:} \code{1} | \emph{scope:} dynamic & static

A value between 0 (fully transparent) and 1 (fully opaque).}

\item{key}{\emph{Draw individual marker legends?}

\emph{default:} \code{FALSE} | \emph{scope:} dynamic & static

Draw a key for each individual marker? Potentially useful when \code{limits = "free"}, but of limited use otherwise.}

\item{legend}{\emph{Draw a shared legend?}

\emph{default:} \code{TRUE} | \emph{scope:} dynamic & static

When all markers share the same colour scale (e.g., when \code{limits != "free"}
in \code{\link[=polarMap]{polarMap()}}), should a shared legend be created at the side of the map?}

\item{legend.position}{\emph{Position of the shared legend.}

\emph{default:} \code{NULL} | \emph{scope:} dynamic & static

When \code{legend = TRUE}, where should the legend be placed?
\itemize{
\item \emph{Dynamic}: One of "topright", "topright", "bottomleft" or "bottomright". Passed to the \code{position} argument of \code{\link[leaflet:addLegend]{leaflet::addLegend()}}.
\item \emph{Static:}: One of "top", "right", "bottom" or "left". Passed to the \code{legend.position} argument of \code{\link[ggplot2:theme]{ggplot2::theme()}}.
}}

\item{legend.title}{\emph{Title of the legend.}

\emph{default:} \code{NULL} | \emph{scope:} dynamic & static

By default, when \code{legend.title = NULL}, the function will attempt to
provide a sensible legend title. \code{legend.title} allows users to overwrite
this - for example, to include units or other contextual information. For
\emph{dynamic} maps, users may wish to use HTML tags to format the title.}

\item{legend.title.autotext}{\emph{Automatically format the title of the legend?}

\emph{default:} \code{TRUE} | \emph{scope:} dynamic & static

When \code{legend.title.autotext = TRUE}, \code{legend.title} will be first run
through \code{\link[=quickTextHTML]{quickTextHTML()}} (\emph{dynamic}) or \code{\link[openair:quickText]{openair::quickText()}} (\emph{static}).}

\item{control.collapsed}{\emph{Show the layer control as a collapsed?}

\emph{default:} \code{FALSE} | \emph{scope:} dynamic

For \emph{dynamic} maps, should the "layer control" interface be collapsed? If
\code{TRUE}, users will have to hover over an icon to view the options.}

\item{control.position}{\emph{Position of the layer control menu}

\emph{default:} \code{"topright"} | \emph{scope:} dynamic

When \code{type != NULL}, or multiple pollutants are specified, where should the
"layer control" interface be placed? One of "topleft", "topright",
"bottomleft" or "bottomright". Passed to the \code{position} argument of
\code{\link[leaflet:addLayersControl]{leaflet::addLayersControl()}}.}

\item{control.autotext}{\emph{Automatically format the content of the layer
control menu?}

\emph{default:} \code{TRUE} | \emph{scope:} dynamic

When \code{control.autotext = TRUE}, the content of the "layer control"
interface will be first run through \code{\link[=quickTextHTML]{quickTextHTML()}}.}

\item{d.icon}{\emph{The diameter of the plot on the map in pixels.}

\emph{default:} \code{200} | \emph{scope:} dynamic & static

This will affect the size of the individual polar markers. Alternatively, a
vector in the form \code{c(width, height)} can be provided if a non-circular
marker is desired.}

\item{d.fig}{\emph{The diameter of the plots to be produced using \code{{openair}} in
inches.}

\emph{default:} \code{3.5} | \emph{scope:} dynamic & static

This will affect the resolution of the markers on the map. Alternatively, a
vector in the form \code{c(width, height)} can be provided if a non-circular
marker is desired.}

\item{static}{\emph{Produce a static map?}

\emph{default:} \code{FALSE}

This controls whether a \emph{dynamic} or \emph{static} map is produced. The former
is the default and is broadly more useful, but the latter may be preferable
for DOCX or PDF outputs (e.g., academic papers).}

\item{static.nrow}{\emph{Number of rows in a static map.}

\emph{default:} \code{NULL} | \emph{scope:} static

Controls the number of rows of panels on a static map when multiple
\code{pollutant}s or \code{type} are specified; passed to the \code{nrow} argument of
\code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}. The default, \code{NULL}, results in a roughly square
grid of panels.}

\item{progress}{\emph{Show a progress bar?}

\emph{default:} \code{TRUE} | \emph{scope:} dynamic & static

By default, a progress bar is shown to visualise the function's progress
creating individual polar markers. This option allows this to be turned
off, if desired.}

\item{...}{
  Arguments passed on to \code{\link[openair:polarAnnulus]{openair::polarAnnulus}}
  \describe{
    \item{\code{resolution}}{Two plot resolutions can be set: \dQuote{normal} and
\dQuote{fine} (the default).}
    \item{\code{local.tz}}{Should the results be calculated in local time that includes
a treatment of daylight savings time (DST)? The default is not to consider
DST issues, provided the data were imported without a DST offset. Emissions
activity tends to occur at local time e.g. rush hour is at 8 am every day.
When the clocks go forward in spring, the emissions are effectively
released into the atmosphere typically 1 hour earlier during the summertime
i.e. when DST applies. When plotting diurnal profiles, this has the effect
of \dQuote{smearing-out} the concentrations. Sometimes, a useful approach
is to express time as local time. This correction tends to produce
better-defined diurnal profiles of concentration (or other variables) and
allows a better comparison to be made with emissions/activity data. If set
to \code{FALSE} then GMT is used. Examples of usage include \code{local.tz
  = "Europe/London"}, \code{local.tz = "America/New_York"}. See
\code{cutData} and \code{import} for more details.}
    \item{\code{statistic}}{The statistic that should be applied to each wind
speed/direction bin. Can be \dQuote{mean} (default), \dQuote{median},
\dQuote{max} (maximum), \dQuote{frequency}. \dQuote{stdev} (standard
deviation), \dQuote{weighted.mean} or \dQuote{cpf} (Conditional Probability
Function). Because of the smoothing involved, the colour scale for some of
these statistics is only to provide an indication of overall pattern and
should not be interpreted in concentration units e.g. for \code{statistic =
  "weighted.mean"} where the bin mean is multiplied by the bin frequency and
divided by the total frequency. In many cases using \code{polarFreq} will
be better. Setting \code{statistic = "weighted.mean"} can be useful because
it provides an indication of the concentration * frequency of occurrence
and will highlight the wind speed/direction conditions that dominate the
overall mean.}
    \item{\code{percentile}}{If \code{statistic = "percentile"} or \code{statistic =
  "cpf"} then \code{percentile} is used, expressed from 0 to 100. Note that
the percentile value is calculated in the wind speed, wind direction
\sQuote{bins}. For this reason it can also be useful to set \code{min.bin}
to ensure there are a sufficient number of points available to estimate a
percentile. See \code{quantile} for more details of how percentiles are
calculated.}
    \item{\code{width}}{The width of the annulus; can be \dQuote{normal} (the default),
\dQuote{thin} or \dQuote{fat}.}
    \item{\code{min.bin}}{The minimum number of points allowed in a wind speed/wind
direction bin.  The default is 1. A value of two requires at least 2 valid
records in each bin an so on; bins with less than 2 valid records are set
to NA. Care should be taken when using a value > 1 because of the risk of
removing real data points. It is recommended to consider your data with
care. Also, the \code{polarFreq} function can be of use in such
circumstances.}
    \item{\code{exclude.missing}}{Setting this option to \code{TRUE} (the default)
removes points from the plot that are too far from the original data. The
smoothing routines will produce predictions at points where no data exist
i.e. they predict. By removing the points too far from the original data
produces a plot where it is clear where the original data lie. If set to
\code{FALSE} missing data will be interpolated.}
    \item{\code{date.pad}}{For \code{type = "trend"} (default), \code{date.pad = TRUE}
will pad-out missing data to the beginning of the first year and the end of
the last year. The purpose is to ensure that the trend plot begins and ends
at the beginning or end of year.}
    \item{\code{force.positive}}{The default is \code{TRUE}. Sometimes if smoothing data
with steep gradients it is possible for predicted values to be negative.
\code{force.positive = TRUE} ensures that predictions remain positive. This
is useful for several reasons. First, with lots of missing data more
interpolation is needed and this can result in artefacts because the
predictions are too far from the original data. Second, if it is known
beforehand that the data are all positive, then this option carries that
assumption through to the prediction. The only likely time where setting
\code{force.positive = FALSE} would be if background concentrations were
first subtracted resulting in data that is legitimately negative. For the
vast majority of situations it is expected that the user will not need to
alter the default option.}
    \item{\code{k}}{The smoothing value supplied to \code{gam} for the temporal and wind
direction components, respectively. In some cases e.g. a trend plot with
less than 1-year of data the smoothing with the default values may become
too noisy and affected more by outliers. Choosing a lower value of \code{k}
(say 10) may help produce a better plot.}
    \item{\code{normalise}}{If \code{TRUE} concentrations are normalised by dividing by
their mean value. This is done \emph{after} fitting the smooth surface.
This option is particularly useful if one is interested in the patterns of
concentrations for several pollutants on different scales e.g. NOx and CO.
Often useful if more than one \code{pollutant} is chosen.}
    \item{\code{key.header}}{Adds additional text/labels to the scale key. For example,
passing the options \code{key.header = "header", key.footer = "footer1"}
adds addition text above and below the scale key. These arguments are
passed to \code{drawOpenKey} via \code{quickText}, applying the
\code{auto.text} argument, to handle formatting.}
    \item{\code{key.footer}}{see \code{key.footer}.}
    \item{\code{key.position}}{Location where the scale key is to plotted. Allowed
arguments currently include \code{"top"}, \code{"right"}, \code{"bottom"}
and \code{"left"}.}
    \item{\code{auto.text}}{Either \code{TRUE} (default) or \code{FALSE}. If \code{TRUE}
titles and axis labels will automatically try and format pollutant names
and units properly e.g.  by subscripting the `2' in NO2.}
  }}

\item{control}{\strong{Deprecated.} Please use \code{type}.}
}
\value{
Either:
\itemize{
\item \emph{Dynamic:} A leaflet object
\item \emph{Static:} A \code{ggplot2} object using \code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}} coordinates with a \code{ggspatial} basemap
}
}
\description{
The \code{\link[=annulusMap]{annulusMap()}} function creates a map using polar annulus plots as
markers. Any number of pollutants can be specified using the \code{pollutant}
argument, and multiple layers of markers can be created using \code{type}. By
default, these maps are dynamic and can be panned, zoomed, and otherwise
interacted with. Using the \code{static} argument allows for static images to be
produced instead.
}
\section{Customisation of static maps using ggplot2}{


As the outputs of the static directional analysis functions are \code{ggplot2}
figures, further customisation is possible using functions such as
\code{\link[ggplot2:theme]{ggplot2::theme()}}, \code{\link[ggplot2:guides]{ggplot2::guides()}} and \code{\link[ggplot2:labs]{ggplot2::labs()}}.

If multiple pollutants are specified, subscripting (e.g., the "x" in "NOx")
is achieved using the \link[ggtext:ggtext]{ggtext} package. Therefore if you
choose to override the plot theme, it is recommended to use
\verb{[ggplot2::theme()]} and \verb{[ggtext::element_markdown()]} to define the
\code{strip.text} parameter.

When arguments like \code{limits}, \code{percentile} or \code{breaks} are defined, a
legend is automatically added to the figure. Legends can be removed using
\code{ggplot2::theme(legend.position = "none")}, or further customised using
\code{\link[ggplot2:guides]{ggplot2::guides()}} and either \code{color = ggplot2::guide_colourbar()} for
continuous legends or \code{fill = ggplot2::guide_legend()} for discrete
legends.
}

\examples{
\dontrun{
annulusMap(polar_data,
  pollutant = "nox",
  period = "hour",
  provider = "CartoDB.Voyager"
)
}
}
\seealso{
\code{\link[openair:polarAnnulus]{openair::polarAnnulus()}}

Other directional analysis maps: 
\code{\link{diffMap}()},
\code{\link{freqMap}()},
\code{\link{percentileMap}()},
\code{\link{polarMap}()},
\code{\link{pollroseMap}()},
\code{\link{windroseMap}()}
}
\concept{directional analysis maps}
