% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_gurobi_solver.R
\name{add_gurobi_solver}
\alias{add_gurobi_solver}
\title{Add a \pkg{Gurobi} solver}
\usage{
add_gurobi_solver(
  x,
  gap = 0,
  number_solutions = 1,
  solution_pool_method = 2,
  time_limit = .Machine$integer.max,
  presolve = 2,
  threads = 1,
  first_feasible = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{\linkS4class{ProjectProblem} object.}

\item{gap}{\code{numeric} gap to optimality. This gap is relative
and expresses the acceptable deviance from the optimal objective.
For example, a value of 0.01 will result in the solver stopping when
it has found a solution within 1\% of optimality.
Additionally, a value of 0 will result in the solver stopping
when it has found an optimal solution.
The default value is 0.1 (i.e. 10\% from optimality).}

\item{number_solutions}{\code{integer} number of solutions desired.
Defaults to 1. Note that the number of returned solutions can sometimes
be less than the argument to \code{number_solutions} depending on the
argument to \code{solution_pool_method}, for example if 100
solutions are requested but only 10 unique solutions exist, then only 10
solutions will be returned.}

\item{solution_pool_method}{\code{numeric} search method identifier that
determines how multiple solutions should be generated. Available search
modes for generating a portfolio of solutions include: \code{0}
recording all solutions identified whilst trying to find
a solution that is within the specified optimality gap, \code{1} finding
one solution within the optimality gap and a number of additional
solutions that are of any level of quality (such that the total number of
solutions is equal to \code{number_solutions}), and \code{2} finding a
specified number of solutions that are nearest to optimality. For more
information, see the \emph{Gurobi} manual (i.e. \url{https://docs.gurobi.com/projects/optimizer/en/current/reference/parameters.html#poolsearchmode}). Defaults to 2.}

\item{time_limit}{\code{numeric} time limit in seconds to run the optimizer.
The solver will return the current best solution when this time limit is
exceeded.}

\item{presolve}{\code{integer} number indicating how intensively the
solver should try to simplify the problem before solving it. The default
value of 2 indicates to that the solver should be very aggressive in
trying to simplify the problem.}

\item{threads}{\code{integer} number of threads to use for the
optimization algorithm. The default value of 1 will result in only
one thread being used.}

\item{first_feasible}{\code{logical} should the first feasible solution be
be returned? If \code{first_feasible} is set to \code{TRUE}, the solver
will return the first solution it encounters that meets all the
constraints, regardless of solution quality. Note that the first feasible
solution is not an arbitrary solution, rather it is derived from the
relaxed solution, and is therefore often reasonably close to optimality.
Defaults to \code{FALSE}.}

\item{verbose}{\code{logical} should information be printed while solving
optimization problems?}
}
\value{
\linkS4class{ProjectProblem} object with the solver added
to it.
}
\description{
Specify that the \emph{Gurobi} software should be used to solve a
project prioritization \code{\link[=problem]{problem()}}. This function can also be
used to customize the behavior of the solver. In addition to the
\emph{Gurobi} software suite, it also requires the \pkg{gurobi} package to
be installed.
}
\details{
\href{https://www.gurobi.com}{\emph{Gurobi}} is a
state-of-the-art commercial optimization software with an R package
interface. It is by far the fastest of the solvers supported by this
package, however, it is also the only solver that is not freely
available. That said, licenses are available to academics at no cost. The
\pkg{gurobi} package is distributed with the \emph{Gurobi} software suite.
This solver uses the \pkg{gurobi} package to solve problems.

To install the \pkg{gurobi} package, the
\href{https://www.gurobi.com}{Gurobi} optimization suite will first need to
be installed (see \url{https://support.gurobi.com/hc/en-us/articles/4534161999889-How-do-I-install-Gurobi-Optimizer} for instructions). Although
\href{https://www.gurobi.com}{Gurobi} is a commercial software, academics
can obtain a
\href{https://www.gurobi.com/downloads/end-user-license-agreement-academic/}{special license for no cost}. After installing the
\href{https://www.gurobi.com}{Gurobi} optimization suite, the \pkg{gurobi}
package can then be installed (see \url{https://support.gurobi.com/hc/en-us/articles/14462206790033-How-do-I-install-Gurobi-for-R} for instructions).
}
\examples{
\dontrun{
# load data
data(sim_projects, sim_features, sim_actions)

# build problem
p1 <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
     add_max_richness_objective(budget = 200) \%>\%
     add_binary_decisions()

# build another problem, and specify the Gurobi solver
p2 <- p1 \%>\%
      add_gurobi_solver()

# print problem
print(p2)

# solve problem
s2 <- solve(p2)

# print solution
print(s2)

# plot solution
plot(p2, s2)

# build another problem and obtain multiple solutions
# note that this problem doesn't have 100 unique solutions so
# the solver won't return 100 solutions
p3 <- p1 \%>\%
      add_gurobi_solver(number_solutions = 100)

# print problem
print(p3)

# solve problem
s3 <- solve(p3)

# print solutions
print(s3)
}
}
\seealso{
\link{solvers}.
}
