% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_ordinal_variation.R
\encoding{UTF-8}
\name{index_ordinal_variation}
\alias{index_ordinal_variation}
\title{Computes the  estimated index of ordinal variation (IOV) of an ordinal time series}
\usage{
index_ordinal_variation(series, states)
}
\arguments{
\item{series}{An OTS.}

\item{states}{A numerical vector containing the corresponding
states.}
}
\value{
The estimated IOV.
}
\description{
\code{index_ordinal_variation} computes the estimated index of ordinal variation
of an ordinal time series
}
\details{
Given an OTS of length \eqn{T} with range \eqn{\mathcal{S}=\{s_0, s_1, s_2, \ldots, s_n\}} (\eqn{s_0 < s_1 < s_2 < \ldots < s_n}),
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the
estimated IOV given by \eqn{\widehat{IOV}=\frac{4}{n}\sum_{k=1}^{n-1}\widehat{f}_k(1-\widehat{f}_k)},
where \eqn{\widehat{f}_k} is the standard estimate of the cumulative marginal probability
for state \eqn{s_k} computed from the series \eqn{\overline{X}_t}.
}
\examples{
estimated_iov <- index_ordinal_variation(series = AustrianWages$data[[100]],
states = 0 : 5) # Computing the estimate of the IOV
# for one series in dataset AustrianWages
}
\references{
{

  \insertRef{weiss2019distance}{otsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
