% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinal_dispersion_2.R
\encoding{UTF-8}
\name{ordinal_dispersion_2}
\alias{ordinal_dispersion_2}
\title{Computes the estimated dispersion of an ordinal time series according to
the approach based on the diversity coefficient (DIVC)}
\usage{
ordinal_dispersion_2(series, states, distance = "Block", normalize = FALSE)
}
\arguments{
\item{series}{An OTS.}

\item{states}{A numerical vector containing the corresponding
states.}

\item{distance}{A function defining the underlying distance between
states. The Hamming, block and Euclidean distances are already
implemented by means of the arguments "Hamming", "Block" (default)
and "Euclidean". Otherwise, a function taking as input two states must
be provided.}

\item{normalize}{Logical. If \code{normalize = FALSE} (default), the value of the estimated dispersion is returned. Otherwise, the function
returns the normalized estimated dispersion.}
}
\value{
The estimated dispersion according to the approach based on the
diversity coefficient.
}
\description{
\code{ordinal_dispersion_2} computes the estimated dispersion
of an ordinal time series according to the approach based on the
diversity coefficient
}
\details{
Given an OTS of length \eqn{T} with range \eqn{\mathcal{S}=\{s_0, s_1, s_2, \ldots, s_n\}} (\eqn{s_0 < s_1 < s_2 < \ldots < s_n}),
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the DIVC
estimated dispersion given by \eqn{\widehat{disp}_{d}=\frac{T}{T-1}\sum_{i,j=0}^nd\big(s_i, s_j\big)\widehat{p}_i\widehat{p}_j},
where \eqn{d(\cdot, \cdot)} is a distance between ordinal states and \eqn{\widehat{p}_k} is the
standard estimate of the marginal probability for state \eqn{s_k}.
If \code{normalize = TRUE}, and \code{distance = "Block"} or \code{distance = "Euclidean"}, then the normalized versions are computed, that is,
the corresponding estimates are divided by the factors \eqn{2/m} or \eqn{2/m^2}, respectively.
}
\examples{
estimated_dispersion <- ordinal_dispersion_2(series = AustrianWages$data[[100]],
states = 0 : 5) # Computing the DIVC dispersion estimate
# for one series in dataset AustrianWages using the block distance
}
\references{
{

  \insertRef{weiss2019distance}{otsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
