% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtw.R
\name{get_dtw_dist_mat}
\alias{get_dtw_dist_mat}
\title{DTW distance matrix for all genes}
\usage{
get_dtw_dist_mat(
  data,
  ptime,
  slide_window_size = 50,
  slide_step_size = 25,
  cores = 2
)
}
\arguments{
\item{data}{gene expression matrix (Gene * Cells)}

\item{ptime}{pseudotime matched with the column cells of the gene expression matrix}

\item{slide_window_size}{sliding window size}

\item{slide_step_size}{sliding window step size}

\item{cores}{number of cores for parallel computing}
}
\value{
bidirectional DTW distance matrix
}
\description{
Get DTW distance matrix for all genes using pseudotime based sliding window transfromation,
parallel computing allowed.
}
\examples{
example_data <- pGRNDB
expression_matrix <- example_data[["expression"]]
pseudotime_list <- example_data[["ptime"]]$PseudoTime
dtw_dist_matrix <- get_dtw_dist_mat(expression_matrix,
                                    pseudotime_list,
                                    cores=1)

}
