% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_land_mask.R
\name{get_land_mask}
\alias{get_land_mask}
\title{Get the land mask for a dataset.}
\usage{
get_land_mask(time_bp = NULL, time_ce = NULL, dataset)
}
\arguments{
\item{time_bp}{time slices in years before present (negative values represent
time before present, positive values time in the future). This parameter
can be a vector of times (the slices need to exist in the dataset), a list
with a min and max element setting the range of values, or left to NULL to
retrieve all time steps. To check which slices are available, you can use
\code{\link[=get_time_bp_steps]{get_time_bp_steps()}}.}

\item{time_ce}{time in years CE as an alternative to \code{time_bp}.Only one of
\code{time_bp} or \code{time_ce} should be used. For available time slices in years
CE, use \code{\link[=get_time_ce_steps]{get_time_ce_steps()}}.}

\item{dataset}{string defining dataset to be downloaded (a list of possible
values can be obtained with \code{\link[=list_available_datasets]{list_available_datasets()}}). This function
will not work on custom datasets.}
}
\value{
a binary \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} with the land mask as 1s
}
\description{
Get the land mask for a dataset, either for the whole series or for specific
time points.
}
